/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.autoconfigure.EnableAutoConfigurationImportSelector;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

class ImportAutoConfigurationImportSelector
extends EnableAutoConfigurationImportSelector {
    private static final Set<String> ANNOTATION_NAMES;

    ImportAutoConfigurationImportSelector() {
    }

    @Override
    protected AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        return null;
    }

    @Override
    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        try {
            return this.getCandidateConfigurations(ClassUtils.forName((String)metadata.getClassName(), null));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private List<String> getCandidateConfigurations(Class<?> source) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        this.collectCandidateConfigurations(source, candidates, new HashSet());
        return new ArrayList<String>(candidates);
    }

    private void collectCandidateConfigurations(Class<?> source, Set<String> candidates, Set<Class<?>> seen) {
        if (source != null && seen.add(source)) {
            for (Annotation annotation : source.getDeclaredAnnotations()) {
                if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation)) continue;
                this.collectCandidateConfigurations(source, annotation, candidates, seen);
            }
            this.collectCandidateConfigurations(source.getSuperclass(), candidates, seen);
        }
    }

    private void collectCandidateConfigurations(Class<?> source, Annotation annotation, Set<String> candidates, Set<Class<?>> seen) {
        if (ANNOTATION_NAMES.contains(annotation.annotationType().getName())) {
            candidates.addAll(this.getConfigurationsForAnnotation(source, annotation));
        }
        this.collectCandidateConfigurations(annotation.annotationType(), candidates, seen);
    }

    private Collection<String> getConfigurationsForAnnotation(Class<?> source, Annotation annotation) {
        String[] value = (String[])AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)true).get("value");
        if (value.length > 0) {
            return Arrays.asList(value);
        }
        return SpringFactoriesLoader.loadFactoryNames(source, (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    protected Set<String> getExclusions(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        return Collections.emptySet();
    }

    @Override
    public int getOrder() {
        return super.getOrder() - 1;
    }

    static {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(ImportAutoConfiguration.class.getName());
        names.add("org.springframework.boot.autoconfigure.test.ImportAutoConfiguration");
        ANNOTATION_NAMES = Collections.unmodifiableSet(names);
    }
}

