/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnClass(value={SpringEmbeddedCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@Conditional(value={CacheCondition.class})
public class InfinispanCacheConfiguration {
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired(required=false)
    private ConfigurationBuilder defaultConfigurationBuilder;

    @Bean
    public SpringEmbeddedCacheManager cacheManager(EmbeddedCacheManager embeddedCacheManager) {
        return new SpringEmbeddedCacheManager(embeddedCacheManager);
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean
    public EmbeddedCacheManager infinispanCacheManager() throws IOException {
        EmbeddedCacheManager cacheManager = this.createEmbeddedCacheManager();
        List<String> cacheNames = this.cacheProperties.getCacheNames();
        if (!CollectionUtils.isEmpty(cacheNames)) {
            for (String cacheName : cacheNames) {
                cacheManager.defineConfiguration(cacheName, this.getDefaultCacheConfiguration());
            }
        }
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedCacheManager createEmbeddedCacheManager() throws IOException {
        Resource location = this.cacheProperties.resolveConfigLocation(this.cacheProperties.getInfinispan().getConfig());
        if (location != null) {
            InputStream in = location.getInputStream();
            try {
                DefaultCacheManager defaultCacheManager = new DefaultCacheManager(in);
                return defaultCacheManager;
            }
            finally {
                in.close();
            }
        }
        return new DefaultCacheManager();
    }

    private org.infinispan.configuration.cache.Configuration getDefaultCacheConfiguration() {
        if (this.defaultConfigurationBuilder != null) {
            return this.defaultConfigurationBuilder.build();
        }
        return new ConfigurationBuilder().build();
    }
}

