/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.sbom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.sbom.SbomProperties;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Endpoint(id="sbom")
@ImportRuntimeHints(value={SbomEndpointRuntimeHints.class})
public class SbomEndpoint {
    static final String APPLICATION_SBOM_ID = "application";
    private static final List<AutodetectedSbom> AUTODETECTED_SBOMS = List.of(new AutodetectedSbom("application", "classpath:META-INF/sbom/bom.json", true), new AutodetectedSbom("application", "classpath:META-INF/sbom/application.cdx.json", true), new AutodetectedSbom("native-image", "classpath:META-INF/native-image/sbom.json", false));
    private final SbomProperties properties;
    private final ResourceLoader resourceLoader;
    private final Map<String, Resource> sboms;

    public SbomEndpoint(SbomProperties properties, ResourceLoader resourceLoader) {
        this.properties = properties;
        this.resourceLoader = resourceLoader;
        this.sboms = this.loadSboms();
    }

    private Map<String, Resource> loadSboms() {
        HashMap<String, Resource> sboms = new HashMap<String, Resource>();
        this.addConfiguredApplicationSbom(sboms);
        this.addAdditionalSboms(sboms);
        this.addAutodetectedSboms(sboms);
        return Collections.unmodifiableMap(sboms);
    }

    private void addConfiguredApplicationSbom(Map<String, Resource> sboms) {
        String location = this.properties.getApplication().getLocation();
        if (!StringUtils.hasLength((String)location)) {
            return;
        }
        Resource resource = this.loadResource(location);
        if (resource != null) {
            sboms.put(APPLICATION_SBOM_ID, resource);
        }
    }

    private void addAdditionalSboms(Map<String, Resource> result) {
        this.properties.getAdditional().forEach((id, sbom) -> {
            Resource resource = this.loadResource(sbom.getLocation());
            if (resource != null && result.putIfAbsent((String)id, resource) != null) {
                throw new IllegalStateException("Duplicate SBOM registration with id '%s'".formatted(id));
            }
        });
    }

    private void addAutodetectedSboms(Map<String, Resource> sboms) {
        for (AutodetectedSbom sbom : AUTODETECTED_SBOMS) {
            Resource resource;
            if (sboms.containsKey(sbom.id()) || !(resource = this.resourceLoader.getResource(sbom.resource())).exists()) continue;
            sboms.put(sbom.id(), resource);
        }
    }

    private @Nullable Resource loadResource(@Nullable String location) {
        if (location == null) {
            return null;
        }
        Location parsedLocation = Location.of(location);
        Resource resource = this.resourceLoader.getResource(parsedLocation.location());
        if (resource.exists()) {
            return resource;
        }
        if (parsedLocation.optional()) {
            return null;
        }
        throw new IllegalStateException("Resource '%s' doesn't exist and it's not marked optional".formatted(location));
    }

    @ReadOperation
    Sboms sboms() {
        return new Sboms(new TreeSet<String>(this.sboms.keySet()));
    }

    @ReadOperation
    @Nullable Resource sbom(@Selector String id) {
        return this.sboms.get(id);
    }

    private record AutodetectedSbom(String id, String resource, boolean needsHints) {
        void registerHintsIfNeeded(RuntimeHints hints) {
            if (this.needsHints) {
                hints.resources().registerPattern(this.stripClasspathPrefix(this.resource));
            }
        }

        private String stripClasspathPrefix(String location) {
            return location.substring("classpath:".length());
        }
    }

    private record Location(String location, boolean optional) {
        private static final String OPTIONAL_PREFIX = "optional:";

        static Location of(String location) {
            boolean optional = Location.isOptional(location);
            return new Location(optional ? Location.stripOptionalPrefix(location) : location, optional);
        }

        private static boolean isOptional(String location) {
            return location.startsWith(OPTIONAL_PREFIX);
        }

        private static String stripOptionalPrefix(String location) {
            return location.substring(OPTIONAL_PREFIX.length());
        }
    }

    record Sboms(Collection<String> ids) implements OperationResponseBody
    {
    }

    static class SbomEndpointRuntimeHints
    implements RuntimeHintsRegistrar {
        SbomEndpointRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            for (AutodetectedSbom sbom : AUTODETECTED_SBOMS) {
                sbom.registerHintsIfNeeded(hints);
            }
        }
    }
}

