/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.logging;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.annotation.RegisterReflectionForBinding;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggerGroup;
import org.springframework.boot.logging.LoggerGroups;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.util.Assert;

@Endpoint(id="loggers")
@RegisterReflectionForBinding(value={GroupLoggerLevelsDescriptor.class, SingleLoggerLevelsDescriptor.class})
public class LoggersEndpoint {
    private final LoggingSystem loggingSystem;
    private final LoggerGroups loggerGroups;

    public LoggersEndpoint(LoggingSystem loggingSystem, LoggerGroups loggerGroups) {
        Assert.notNull((Object)loggingSystem, (String)"'loggingSystem' must not be null");
        Assert.notNull((Object)loggerGroups, (String)"'loggerGroups' must not be null");
        this.loggingSystem = loggingSystem;
        this.loggerGroups = loggerGroups;
    }

    @ReadOperation
    public LoggersDescriptor loggers() {
        List configurations = this.loggingSystem.getLoggerConfigurations();
        if (configurations == null) {
            return LoggersDescriptor.NONE;
        }
        return new LoggersDescriptor(this.getLevels(), this.getLoggers(configurations), this.getGroups());
    }

    private Map<String, GroupLoggerLevelsDescriptor> getGroups() {
        LinkedHashMap<String, GroupLoggerLevelsDescriptor> groups = new LinkedHashMap<String, GroupLoggerLevelsDescriptor>();
        this.loggerGroups.forEach(group -> groups.put(group.getName(), new GroupLoggerLevelsDescriptor(group.getConfiguredLevel(), group.getMembers())));
        return groups;
    }

    @ReadOperation
    public @Nullable LoggerLevelsDescriptor loggerLevels(@Selector String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        LoggerGroup group = this.loggerGroups.get(name);
        if (group != null) {
            return new GroupLoggerLevelsDescriptor(group.getConfiguredLevel(), group.getMembers());
        }
        LoggerConfiguration configuration = this.loggingSystem.getLoggerConfiguration(name);
        return configuration != null ? new SingleLoggerLevelsDescriptor(configuration) : null;
    }

    @WriteOperation
    public void configureLogLevel(@Selector String name, @Nullable LogLevel configuredLevel) {
        Assert.notNull((Object)name, (String)"'name' must not be empty");
        LoggerGroup group = this.loggerGroups.get(name);
        if (group != null && group.hasMembers()) {
            group.configureLogLevel(configuredLevel, (arg_0, arg_1) -> ((LoggingSystem)this.loggingSystem).setLogLevel(arg_0, arg_1));
            return;
        }
        this.loggingSystem.setLogLevel(name, configuredLevel);
    }

    private NavigableSet<LogLevel> getLevels() {
        Set levels = this.loggingSystem.getSupportedLogLevels();
        return new TreeSet(levels).descendingSet();
    }

    private Map<String, LoggerLevelsDescriptor> getLoggers(Collection<LoggerConfiguration> configurations) {
        LinkedHashMap<String, LoggerLevelsDescriptor> loggers = new LinkedHashMap<String, LoggerLevelsDescriptor>(configurations.size());
        for (LoggerConfiguration configuration : configurations) {
            loggers.put(configuration.getName(), new SingleLoggerLevelsDescriptor(configuration));
        }
        return loggers;
    }

    public static class LoggersDescriptor
    implements OperationResponseBody {
        public static final LoggersDescriptor NONE = new LoggersDescriptor(null, null, null);
        private final @Nullable NavigableSet<LogLevel> levels;
        private final @Nullable Map<String, LoggerLevelsDescriptor> loggers;
        private final @Nullable Map<String, GroupLoggerLevelsDescriptor> groups;

        public LoggersDescriptor(@Nullable NavigableSet<LogLevel> levels, @Nullable Map<String, LoggerLevelsDescriptor> loggers, @Nullable Map<String, GroupLoggerLevelsDescriptor> groups) {
            this.levels = levels;
            this.loggers = loggers;
            this.groups = groups;
        }

        public @Nullable NavigableSet<LogLevel> getLevels() {
            return this.levels;
        }

        public @Nullable Map<String, LoggerLevelsDescriptor> getLoggers() {
            return this.loggers;
        }

        public @Nullable Map<String, GroupLoggerLevelsDescriptor> getGroups() {
            return this.groups;
        }
    }

    public static class GroupLoggerLevelsDescriptor
    extends LoggerLevelsDescriptor {
        private final List<String> members;

        public GroupLoggerLevelsDescriptor(@Nullable LogLevel configuredLevel, List<String> members) {
            super(configuredLevel);
            this.members = members;
        }

        public List<String> getMembers() {
            return this.members;
        }
    }

    public static class SingleLoggerLevelsDescriptor
    extends LoggerLevelsDescriptor {
        private final String effectiveLevel;

        public SingleLoggerLevelsDescriptor(LoggerConfiguration configuration) {
            super(configuration.getLevelConfiguration(LoggerConfiguration.ConfigurationScope.DIRECT));
            this.effectiveLevel = configuration.getLevelConfiguration().getName();
        }

        public String getEffectiveLevel() {
            return this.effectiveLevel;
        }
    }

    public static class LoggerLevelsDescriptor
    implements OperationResponseBody {
        private final @Nullable String configuredLevel;

        public LoggerLevelsDescriptor(@Nullable LogLevel configuredLevel) {
            this.configuredLevel = configuredLevel != null ? configuredLevel.name() : null;
        }

        LoggerLevelsDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable LoggerConfiguration.LevelConfiguration directConfiguration) {
            this.configuredLevel = directConfiguration != null ? directConfiguration.getName() : null;
        }

        protected final @Nullable String getName(@Nullable LogLevel level) {
            return level != null ? level.name() : null;
        }

        public @Nullable String getConfiguredLevel() {
            return this.configuredLevel;
        }
    }
}

