/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.List;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.util.Assert;

public abstract class AbstractExposableEndpoint<O extends Operation>
implements ExposableEndpoint<O> {
    private final EndpointId id;
    private final Access defaultAccess;
    private final List<O> operations;

    public AbstractExposableEndpoint(EndpointId id, Access defaultAccess, Collection<? extends O> operations) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull(operations, (String)"'operations' must not be null");
        this.id = id;
        this.defaultAccess = defaultAccess;
        this.operations = List.copyOf(operations);
    }

    @Override
    public EndpointId getEndpointId() {
        return this.id;
    }

    @Override
    public Access getDefaultAccess() {
        return this.defaultAccess;
    }

    @Override
    public Collection<O> getOperations() {
        return this.operations;
    }
}

