/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.context.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.context.properties.BeanSerializer;
import org.springframework.boot.actuate.context.properties.Jackson2BeanSerializer;
import org.springframework.boot.actuate.context.properties.JacksonBeanSerializer;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.context.properties.BoundConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Endpoint(id="configprops")
public class ConfigurationPropertiesReportEndpoint
implements ApplicationContextAware {
    private final Sanitizer sanitizer;
    private final Show showValues;
    private final BeanSerializer serializer;
    private ApplicationContext context;

    public ConfigurationPropertiesReportEndpoint(Iterable<SanitizingFunction> sanitizingFunctions, Show showValues) {
        this.sanitizer = new Sanitizer(sanitizingFunctions);
        this.showValues = showValues;
        this.serializer = ConfigurationPropertiesReportEndpoint.getBeanSerializer();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    @ReadOperation
    public ConfigurationPropertiesDescriptor configurationProperties() {
        boolean showUnsanitized = this.showValues.isShown(true);
        return this.getConfigurationProperties(showUnsanitized);
    }

    ConfigurationPropertiesDescriptor getConfigurationProperties(boolean showUnsanitized) {
        return this.getConfigurationProperties(this.context, bean -> true, showUnsanitized);
    }

    @ReadOperation
    public ConfigurationPropertiesDescriptor configurationPropertiesWithPrefix(@Selector String prefix) {
        boolean showUnsanitized = this.showValues.isShown(true);
        return this.getConfigurationProperties(prefix, showUnsanitized);
    }

    ConfigurationPropertiesDescriptor getConfigurationProperties(String prefix, boolean showUnsanitized) {
        return this.getConfigurationProperties(this.context, bean -> bean.getAnnotation().prefix().startsWith(prefix), showUnsanitized);
    }

    private ConfigurationPropertiesDescriptor getConfigurationProperties(ApplicationContext context, Predicate<ConfigurationPropertiesBean> beanFilterPredicate, boolean showUnsanitized) {
        HashMap<@Nullable String, ContextConfigurationPropertiesDescriptor> contexts = new HashMap<String, ContextConfigurationPropertiesDescriptor>();
        for (ApplicationContext target = context; target != null; target = target.getParent()) {
            contexts.put(target.getId(), this.describeBeans(target, beanFilterPredicate, showUnsanitized));
        }
        return new ConfigurationPropertiesDescriptor(contexts);
    }

    private static BeanSerializer getBeanSerializer() {
        ClassLoader classLoader = ConfigurationPropertiesReportEndpoint.class.getClassLoader();
        if (ClassUtils.isPresent((String)"tools.jackson.databind.json.JsonMapper", (ClassLoader)classLoader)) {
            return new JacksonBeanSerializer();
        }
        if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader)) {
            return new Jackson2BeanSerializer();
        }
        return bean -> {
            throw new IllegalStateException("Jackson is required for the 'configprops' endpoint");
        };
    }

    private ContextConfigurationPropertiesDescriptor describeBeans(ApplicationContext context, Predicate<ConfigurationPropertiesBean> beanFilterPredicate, boolean showUnsanitized) {
        Map beans = ConfigurationPropertiesBean.getAll((ApplicationContext)context);
        Map<String, ConfigurationPropertiesBeanDescriptor> descriptors = beans.values().stream().filter(beanFilterPredicate).collect(Collectors.toMap(ConfigurationPropertiesBean::getName, bean -> this.describeBean((ConfigurationPropertiesBean)bean, showUnsanitized)));
        return new ContextConfigurationPropertiesDescriptor(descriptors, context.getParent() != null ? context.getParent().getId() : null);
    }

    private ConfigurationPropertiesBeanDescriptor describeBean(ConfigurationPropertiesBean bean, boolean showUnsanitized) {
        String prefix = bean.getAnnotation().prefix();
        Map<String, @Nullable Object> serialized = this.safeSerialize(bean.getInstance(), prefix);
        Map<String, @Nullable Object> properties = this.sanitize(prefix, serialized, showUnsanitized);
        Map<String, Object> inputs = this.getInputs(prefix, serialized, showUnsanitized);
        return new ConfigurationPropertiesBeanDescriptor(prefix, properties, inputs);
    }

    private Map<String, @Nullable Object> safeSerialize(@Nullable Object bean, String prefix) {
        try {
            return new HashMap<String, Object>(this.serializer.serialize(bean));
        }
        catch (Exception ex) {
            return new HashMap<String, Object>(Collections.singletonMap("error", "Cannot serialize '" + prefix + "'"));
        }
    }

    private Map<String, @Nullable Object> sanitize(String prefix, Map<String, @Nullable Object> map, boolean showUnsanitized) {
        map.forEach((key, value) -> {
            String qualifiedKey = this.getQualifiedKey(prefix, (String)key);
            if (value instanceof Map) {
                map.put((String)key, this.sanitize(qualifiedKey, (Map)value, showUnsanitized));
            } else if (value instanceof List) {
                map.put((String)key, this.sanitize(qualifiedKey, (List)value, showUnsanitized));
            } else {
                map.put((String)key, this.sanitizeWithPropertySourceIfPresent(qualifiedKey, value, showUnsanitized));
            }
        });
        return map;
    }

    private @Nullable Object sanitizeWithPropertySourceIfPresent(String qualifiedKey, @Nullable Object value, boolean showUnsanitized) {
        ConfigurationPropertyName currentName = this.getCurrentName(qualifiedKey);
        ConfigurationProperty candidate = this.getCandidate(currentName);
        PropertySource<?> propertySource = this.getPropertySource(candidate);
        if (propertySource != null) {
            SanitizableData data = new SanitizableData(propertySource, qualifiedKey, value);
            return this.sanitizer.sanitize(data, showUnsanitized);
        }
        SanitizableData data = new SanitizableData(null, qualifiedKey, value);
        return this.sanitizer.sanitize(data, showUnsanitized);
    }

    private @Nullable PropertySource<?> getPropertySource(@Nullable ConfigurationProperty configurationProperty) {
        if (configurationProperty == null) {
            return null;
        }
        ConfigurationPropertySource source = configurationProperty.getSource();
        Object underlyingSource = source != null ? source.getUnderlyingSource() : null;
        return underlyingSource instanceof PropertySource ? (PropertySource)underlyingSource : null;
    }

    private ConfigurationPropertyName getCurrentName(String qualifiedKey) {
        return ConfigurationPropertyName.adapt((CharSequence)qualifiedKey, (char)'.');
    }

    private @Nullable ConfigurationProperty getCandidate(ConfigurationPropertyName currentName) {
        BoundConfigurationProperties bound = BoundConfigurationProperties.get((ApplicationContext)this.context);
        if (bound == null) {
            return null;
        }
        ConfigurationProperty candidate = bound.get(currentName);
        if (candidate == null && currentName.isLastElementIndexed()) {
            candidate = bound.get(currentName.chop(currentName.getNumberOfElements() - 1));
        }
        return candidate;
    }

    private List<@Nullable Object> sanitize(String prefix, List<Object> list, boolean showUnsanitized) {
        ArrayList<@Nullable Object> sanitized = new ArrayList<Object>();
        int index = 0;
        for (Object item : list) {
            String name = prefix + "[" + index++ + "]";
            if (item instanceof Map) {
                sanitized.add(this.sanitize(name, (Map)item, showUnsanitized));
                continue;
            }
            if (item instanceof List) {
                sanitized.add(this.sanitize(name, (List)item, showUnsanitized));
                continue;
            }
            sanitized.add(this.sanitizeWithPropertySourceIfPresent(name, item, showUnsanitized));
        }
        return sanitized;
    }

    private Map<String, Object> getInputs(String prefix, Map<String, @Nullable Object> map, boolean showUnsanitized) {
        LinkedHashMap<String, Object> augmented = new LinkedHashMap<String, Object>(map);
        map.forEach((key, value) -> {
            String qualifiedKey = this.getQualifiedKey(prefix, (String)key);
            if (value instanceof Map) {
                augmented.put((String)key, this.getInputs(qualifiedKey, (Map)value, showUnsanitized));
            } else if (value instanceof List) {
                augmented.put((String)key, this.getInputs(qualifiedKey, (List)value, showUnsanitized));
            } else {
                augmented.put((String)key, this.applyInput(qualifiedKey, showUnsanitized));
            }
        });
        return augmented;
    }

    private List<Object> getInputs(String prefix, List<Object> list, boolean showUnsanitized) {
        ArrayList<Object> augmented = new ArrayList<Object>();
        int index = 0;
        for (Object item : list) {
            String name = prefix + "[" + index++ + "]";
            if (item instanceof Map) {
                augmented.add(this.getInputs(name, (Map)item, showUnsanitized));
                continue;
            }
            if (item instanceof List) {
                augmented.add(this.getInputs(name, (List)item, showUnsanitized));
                continue;
            }
            augmented.add(this.applyInput(name, showUnsanitized));
        }
        return augmented;
    }

    private Map<String, @Nullable Object> applyInput(String qualifiedKey, boolean showUnsanitized) {
        ConfigurationPropertyName currentName = this.getCurrentName(qualifiedKey);
        ConfigurationProperty candidate = this.getCandidate(currentName);
        PropertySource<?> propertySource = this.getPropertySource(candidate);
        if (propertySource != null) {
            Assert.state((candidate != null ? 1 : 0) != 0, (String)"'candidate' must not be null");
            Object value = this.stringifyIfNecessary(candidate.getValue());
            SanitizableData data = new SanitizableData(propertySource, currentName.toString(), value);
            return this.getInput(candidate, this.sanitizer.sanitize(data, showUnsanitized));
        }
        return Collections.emptyMap();
    }

    private Map<String, @Nullable Object> getInput(ConfigurationProperty candidate, @Nullable Object sanitizedValue) {
        LinkedHashMap<String, @Nullable Object> input = new LinkedHashMap<String, Object>();
        Origin origin = Origin.from((Object)candidate);
        List originParents = Origin.parentsFrom((Object)candidate);
        input.put("value", sanitizedValue);
        input.put("origin", origin != null ? origin.toString() : "none");
        if (!originParents.isEmpty()) {
            input.put("originParents", originParents.stream().map(Object::toString).toArray(String[]::new));
        }
        return input;
    }

    private @Nullable Object stringifyIfNecessary(@Nullable Object value) {
        if (value == null || ClassUtils.isPrimitiveOrWrapper(value.getClass()) || value instanceof String) {
            return value;
        }
        if (CharSequence.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        return "Complex property value " + value.getClass().getName();
    }

    private String getQualifiedKey(String prefix, String key) {
        return (String)(prefix.isEmpty() ? prefix : prefix + ".") + key;
    }

    public static final class ConfigurationPropertiesDescriptor
    implements OperationResponseBody {
        private final Map<@Nullable String, ContextConfigurationPropertiesDescriptor> contexts;

        ConfigurationPropertiesDescriptor(Map<@Nullable String, ContextConfigurationPropertiesDescriptor> contexts) {
            this.contexts = contexts;
        }

        public Map<@Nullable String, ContextConfigurationPropertiesDescriptor> getContexts() {
            return this.contexts;
        }
    }

    public static final class ContextConfigurationPropertiesDescriptor {
        private final Map<String, ConfigurationPropertiesBeanDescriptor> beans;
        private final @Nullable String parentId;

        private ContextConfigurationPropertiesDescriptor(Map<String, ConfigurationPropertiesBeanDescriptor> beans, @Nullable String parentId) {
            this.beans = beans;
            this.parentId = parentId;
        }

        public Map<String, ConfigurationPropertiesBeanDescriptor> getBeans() {
            return this.beans;
        }

        public @Nullable String getParentId() {
            return this.parentId;
        }
    }

    public static final class ConfigurationPropertiesBeanDescriptor {
        private final String prefix;
        private final Map<String, @Nullable Object> properties;
        private final Map<String, Object> inputs;

        private ConfigurationPropertiesBeanDescriptor(String prefix, Map<String, @Nullable Object> properties, Map<String, Object> inputs) {
            this.prefix = prefix;
            this.properties = properties;
            this.inputs = inputs;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Map<String, @Nullable Object> getProperties() {
            return this.properties;
        }

        public Map<String, Object> getInputs() {
            return this.inputs;
        }
    }
}

