/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.quartz;

import java.lang.reflect.Type;
import java.util.Set;
import org.quartz.SchedulerException;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.quartz.QuartzEndpoint;
import org.springframework.context.annotation.ImportRuntimeHints;

@EndpointWebExtension(endpoint=QuartzEndpoint.class)
@ImportRuntimeHints(value={QuartzEndpointWebExtensionRuntimeHints.class})
public class QuartzEndpointWebExtension {
    private final QuartzEndpoint delegate;
    private final Show showValues;
    private final Set<String> roles;

    public QuartzEndpointWebExtension(QuartzEndpoint delegate, Show showValues, Set<String> roles) {
        this.delegate = delegate;
        this.showValues = showValues;
        this.roles = roles;
    }

    @ReadOperation
    public WebEndpointResponse<QuartzEndpoint.QuartzGroupsDescriptor> quartzJobOrTriggerGroups(@Selector String jobsOrTriggers) throws SchedulerException {
        return this.handle(jobsOrTriggers, this.delegate::quartzJobGroups, this.delegate::quartzTriggerGroups);
    }

    @ReadOperation
    public WebEndpointResponse<Object> quartzJobOrTriggerGroup(@Selector String jobsOrTriggers, @Selector String group) throws SchedulerException {
        return this.handle(jobsOrTriggers, () -> this.delegate.quartzJobGroupSummary(group), () -> this.delegate.quartzTriggerGroupSummary(group));
    }

    @ReadOperation
    public WebEndpointResponse<Object> quartzJobOrTrigger(SecurityContext securityContext, @Selector String jobsOrTriggers, @Selector String group, @Selector String name) throws SchedulerException {
        boolean showUnsanitized = this.showValues.isShown(securityContext, this.roles);
        return this.handle(jobsOrTriggers, () -> this.delegate.quartzJob(group, name, showUnsanitized), () -> this.delegate.quartzTrigger(group, name, showUnsanitized));
    }

    @WriteOperation
    public WebEndpointResponse<Object> triggerQuartzJob(@Selector String jobs, @Selector String group, @Selector String name, String state) throws SchedulerException {
        if ("jobs".equals(jobs) && "running".equals(state)) {
            return this.handleNull(this.delegate.triggerQuartzJob(group, name));
        }
        return new WebEndpointResponse<int>(400);
    }

    private <T> WebEndpointResponse<T> handle(String jobsOrTriggers, ResponseSupplier<T> jobAction, ResponseSupplier<T> triggerAction) throws SchedulerException {
        if ("jobs".equals(jobsOrTriggers)) {
            return this.handleNull(jobAction.get());
        }
        if ("triggers".equals(jobsOrTriggers)) {
            return this.handleNull(triggerAction.get());
        }
        return new WebEndpointResponse<int>(400);
    }

    private <T> WebEndpointResponse<T> handleNull(T value) {
        return value != null ? new WebEndpointResponse<T>(value) : new WebEndpointResponse<int>(404);
    }

    @FunctionalInterface
    private static interface ResponseSupplier<T> {
        public T get() throws SchedulerException;
    }

    static class QuartzEndpointWebExtensionRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        QuartzEndpointWebExtensionRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{QuartzEndpoint.QuartzGroupsDescriptor.class, QuartzEndpoint.QuartzJobDetailsDescriptor.class, QuartzEndpoint.QuartzJobGroupSummaryDescriptor.class, QuartzEndpoint.QuartzTriggerGroupSummaryDescriptor.class});
        }
    }
}

