/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics;

import io.micrometer.core.instrument.Timer;
import java.util.function.Supplier;

@FunctionalInterface
public interface AutoTimer {
    public static final AutoTimer ENABLED = builder -> {};
    public static final AutoTimer DISABLED = new AutoTimer(){

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void apply(Timer.Builder builder) {
            throw new IllegalStateException("AutoTimer is disabled");
        }
    };

    default public boolean isEnabled() {
        return true;
    }

    default public Timer.Builder builder(String name) {
        return this.builder(() -> Timer.builder((String)name));
    }

    default public Timer.Builder builder(Supplier<Timer.Builder> supplier) {
        Timer.Builder builder = supplier.get();
        this.apply(builder);
        return builder;
    }

    public void apply(Timer.Builder var1);
}

