/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.net.URI;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.web.client.RestTemplateExchangeTagsProvider;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.util.UriTemplateHandler;

class MetricsClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final ThreadLocal<Deque<String>> urlTemplate = new UrlTemplateThreadLocal();
    private final MeterRegistry meterRegistry;
    private final RestTemplateExchangeTagsProvider tagProvider;
    private final String metricName;
    private final AutoTimer autoTimer;

    @Deprecated
    MetricsClientHttpRequestInterceptor(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider tagProvider, String metricName) {
        this(meterRegistry, tagProvider, metricName, AutoTimer.ENABLED);
    }

    MetricsClientHttpRequestInterceptor(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider tagProvider, String metricName, AutoTimer autoTimer) {
        this.tagProvider = tagProvider;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
        this.autoTimer = autoTimer != null ? autoTimer : AutoTimer.DISABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (!this.autoTimer.isEnabled()) {
            return execution.execute(request, body);
        }
        long startTime = System.nanoTime();
        ClientHttpResponse response = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            this.getTimeBuilder(request, response).register(this.meterRegistry).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            if (urlTemplate.get().isEmpty()) {
                urlTemplate.remove();
            }
        }
    }

    UriTemplateHandler createUriTemplateHandler(final UriTemplateHandler delegate) {
        return new UriTemplateHandler(){

            public URI expand(String url, Map<String, ?> arguments) {
                ((Deque)urlTemplate.get()).push(url);
                return delegate.expand(url, arguments);
            }

            public URI expand(String url, Object ... arguments) {
                ((Deque)urlTemplate.get()).push(url);
                return delegate.expand(url, arguments);
            }
        };
    }

    private Timer.Builder getTimeBuilder(HttpRequest request, ClientHttpResponse response) {
        return this.autoTimer.builder(this.metricName).tags(this.tagProvider.getTags(urlTemplate.get().poll(), request, response)).description("Timer of RestTemplate operation");
    }

    private static final class UrlTemplateThreadLocal
    extends NamedThreadLocal<Deque<String>> {
        private UrlTemplateThreadLocal() {
            super("Rest Template URL Template");
        }

        protected Deque<String> initialValue() {
            return new LinkedList<String>();
        }
    }
}

