/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.util.Assert;

public class DefaultReactiveHealthIndicatorRegistry
implements ReactiveHealthIndicatorRegistry {
    private final Object monitor = new Object();
    private final Map<String, ReactiveHealthIndicator> healthIndicators;

    public DefaultReactiveHealthIndicatorRegistry() {
        this(new LinkedHashMap<String, ReactiveHealthIndicator>());
    }

    public DefaultReactiveHealthIndicatorRegistry(Map<String, ReactiveHealthIndicator> healthIndicators) {
        Assert.notNull(healthIndicators, (String)"HealthIndicators must not be null");
        this.healthIndicators = new LinkedHashMap<String, ReactiveHealthIndicator>(healthIndicators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String name, ReactiveHealthIndicator healthIndicator) {
        Assert.notNull((Object)healthIndicator, (String)"HealthIndicator must not be null");
        Assert.notNull((Object)name, (String)"Name must not be null");
        Object object = this.monitor;
        synchronized (object) {
            ReactiveHealthIndicator existing = this.healthIndicators.putIfAbsent(name, healthIndicator);
            if (existing != null) {
                throw new IllegalStateException("HealthIndicator with name '" + name + "' already registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactiveHealthIndicator unregister(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Object object = this.monitor;
        synchronized (object) {
            return this.healthIndicators.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactiveHealthIndicator get(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Object object = this.monitor;
        synchronized (object) {
            return this.healthIndicators.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ReactiveHealthIndicator> getAll() {
        Object object = this.monitor;
        synchronized (object) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, ReactiveHealthIndicator>(this.healthIndicators));
        }
    }
}

