/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.List;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface PathMapper {
    public String getRootPath(EndpointId var1);

    @Deprecated
    public static PathMapper useEndpointId() {
        return EndpointId::toString;
    }

    public static String getRootPath(List<PathMapper> pathMappers, EndpointId endpointId) {
        Assert.notNull((Object)endpointId, (String)"EndpointId must not be null");
        if (pathMappers != null) {
            for (PathMapper mapper : pathMappers) {
                String path = mapper.getRootPath(endpointId);
                if (!StringUtils.hasText((String)path)) continue;
                return path;
            }
        }
        return endpointId.toString();
    }
}

