/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Collection;
import java.util.Objects;
import org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.cache.Cache;

public class CacheMetricsRegistrar {
    private final MeterRegistry registry;
    private final Collection<CacheMeterBinderProvider<?>> binderProviders;

    public CacheMetricsRegistrar(MeterRegistry registry, Collection<CacheMeterBinderProvider<?>> binderProviders) {
        this.registry = registry;
        this.binderProviders = binderProviders;
    }

    public boolean bindCacheToRegistry(Cache cache, Tag ... tags) {
        MeterBinder meterBinder = this.getMeterBinder(cache, Tags.of((Tag[])tags));
        if (meterBinder != null) {
            meterBinder.bindTo(this.registry);
            return true;
        }
        return false;
    }

    private MeterBinder getMeterBinder(Cache cache, Tags tags) {
        Tags cacheTags = tags.and(this.getAdditionalTags(cache));
        return ((LambdaSafe.Callbacks)LambdaSafe.callbacks(CacheMeterBinderProvider.class, this.binderProviders, (Object)cache, (Object[])new Object[0]).withLogger(CacheMetricsRegistrar.class)).invokeAnd(binderProvider -> binderProvider.getMeterBinder(cache, (Iterable<Tag>)cacheTags)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected Iterable<Tag> getAdditionalTags(Cache cache) {
        return Tags.of((String)"name", (String)cache.getName());
    }
}

