/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.liquibase")
public class LiquibaseEndpoint
extends AbstractEndpoint<List<Map<String, ?>>> {
    private final SpringLiquibase liquibase;

    public LiquibaseEndpoint(SpringLiquibase liquibase) {
        super("liquibase");
        Assert.notNull((Object)liquibase, (String)"Liquibase must not be null");
        this.liquibase = liquibase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, ?>> invoke() {
        List list;
        StandardChangeLogHistoryService service = new StandardChangeLogHistoryService();
        DatabaseFactory factory = DatabaseFactory.getInstance();
        DataSource dataSource = this.liquibase.getDataSource();
        JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
        try {
            Database database = factory.findCorrectDatabaseImplementation((DatabaseConnection)connection);
            list = service.queryDatabaseChangeLogTable(database);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to get Liquibase changelog", ex);
            }
        }
        connection.close();
        return list;
    }
}

