/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.boot.autoconfigure.security.SecurityPrerequisite;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management", ignoreUnknownFields=true)
public class ManagementServerProperties
implements SecurityPrerequisite {
    private static final String SECURITY_CHECK_CLASS = "org.springframework.security.config.http.SessionCreationPolicy";
    public static final int BASIC_AUTH_ORDER = 0x7FFFFFF5;
    public static final int ACCESS_OVERRIDE_ORDER = 0x7FFFFFF4;
    private Integer port;
    @NestedConfigurationProperty
    private Ssl ssl;
    private InetAddress address;
    @NotNull
    private String contextPath = "";
    private boolean addApplicationContextHeader = true;
    private final Security security = this.maybeCreateSecurity();

    private Security maybeCreateSecurity() {
        if (ClassUtils.isPresent((String)SECURITY_CHECK_CLASS, null)) {
            return new Security();
        }
        return null;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = this.cleanContextPath(contextPath);
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    public Security getSecurity() {
        return this.security;
    }

    public boolean getAddApplicationContextHeader() {
        return this.addApplicationContextHeader;
    }

    public void setAddApplicationContextHeader(boolean addApplicationContextHeader) {
        this.addApplicationContextHeader = addApplicationContextHeader;
    }

    public static class Security {
        private boolean enabled = true;
        private List<String> roles = Collections.singletonList("ADMIN");
        private SessionCreationPolicy sessions = SessionCreationPolicy.STATELESS;

        public SessionCreationPolicy getSessions() {
            return this.sessions;
        }

        public void setSessions(SessionCreationPolicy sessions) {
            this.sessions = sessions;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @Deprecated
        public void setRole(String role) {
            this.roles = Collections.singletonList(role);
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

