/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class IncludeExcludeGroupMemberPredicate
implements Predicate<String> {
    private final Set<String> include;
    private final Set<String> exclude;

    IncludeExcludeGroupMemberPredicate(Set<String> include, Set<String> exclude) {
        this.include = this.clean(include);
        this.exclude = this.clean(exclude);
    }

    @Override
    public boolean test(String name) {
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    private boolean isIncluded(String name) {
        return this.include.contains("*") || this.include.contains(this.clean(name));
    }

    private boolean isExcluded(String name) {
        return this.exclude.contains("*") || this.exclude.contains(this.clean(name));
    }

    private Set<String> clean(Set<String> names) {
        if (names == null) {
            return Collections.emptySet();
        }
        Set cleaned = names.stream().map(this::clean).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(cleaned);
    }

    private String clean(String name) {
        return name.trim();
    }
}

