/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Map;
import java.util.Optional;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnEnabledEndpointCondition
extends SpringBootCondition {
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";
    private static final ConcurrentReferenceHashMap<Environment, Optional<Boolean>> enabledByDefaultCache = new ConcurrentReferenceHashMap();

    OnEnabledEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        AnnotationAttributes attributes = this.getEndpointAttributes(context, metadata);
        EndpointId id = EndpointId.of((String)attributes.getString("id"));
        String key = "management.endpoint." + id.toLowerCaseString() + ".enabled";
        Boolean userDefinedEnabled = (Boolean)environment.getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome(userDefinedEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("found property " + key + " with value " + userDefinedEnabled));
        }
        Boolean userDefinedDefault = this.isEnabledByDefault(environment);
        if (userDefinedDefault != null) {
            return new ConditionOutcome(userDefinedDefault.booleanValue(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("no property " + key + " found so using user defined default from " + ENABLED_BY_DEFAULT_KEY));
        }
        boolean endpointDefault = attributes.getBoolean("enableByDefault");
        return new ConditionOutcome(endpointDefault, ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because("no property " + key + " found so using endpoint default"));
    }

    private Boolean isEnabledByDefault(Environment environment) {
        Optional<Object> enabledByDefault = (Optional<Object>)enabledByDefaultCache.get((Object)environment);
        if (enabledByDefault == null) {
            enabledByDefault = Optional.ofNullable(environment.getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class));
            enabledByDefaultCache.put((Object)environment, enabledByDefault);
        }
        return enabledByDefault.orElse(null);
    }

    private AnnotationAttributes getEndpointAttributes(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.getEndpointAttributes(this.getEndpointType(context, metadata));
    }

    private Class<?> getEndpointType(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class target;
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnEnabledEndpoint.class.getName());
        if (attributes != null && attributes.containsKey("endpoint") && (target = (Class)attributes.get("endpoint")) != Void.class) {
            return target;
        }
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)"OnEnabledEndpointCondition must be used on @Bean methods when the endpoint is not specified");
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        try {
            return ClassUtils.forName((String)methodMetadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    protected AnnotationAttributes getEndpointAttributes(Class<?> type) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, Endpoint.class, (boolean)true, (boolean)true);
        if (attributes != null) {
            return attributes;
        }
        attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(type, EndpointExtension.class, (boolean)false, (boolean)true);
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"No endpoint is specified and the return type of the @Bean method is neither an @Endpoint, nor an @EndpointExtension");
        return this.getEndpointAttributes(attributes.getClass("endpoint"));
    }
}

