/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.security.reactive.ApplicationContextServerWebExchangeMatcher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class EndpointRequest {
    private static final ServerWebExchangeMatcher EMPTY_MATCHER = request -> ServerWebExchangeMatcher.MatchResult.notMatch();

    private EndpointRequest() {
    }

    public static EndpointServerWebExchangeMatcher toAnyEndpoint() {
        return new EndpointServerWebExchangeMatcher();
    }

    public static EndpointServerWebExchangeMatcher to(Class<?> ... endpoints) {
        return new EndpointServerWebExchangeMatcher(endpoints);
    }

    public static EndpointServerWebExchangeMatcher to(String ... endpoints) {
        return new EndpointServerWebExchangeMatcher(endpoints);
    }

    public static final class EndpointServerWebExchangeMatcher
    extends ApplicationContextServerWebExchangeMatcher<PathMappedEndpoints> {
        private final List<Object> includes;
        private final List<Object> excludes;
        private ServerWebExchangeMatcher delegate;

        private EndpointServerWebExchangeMatcher() {
            this(Collections.emptyList(), Collections.emptyList());
        }

        private EndpointServerWebExchangeMatcher(Class<?>[] endpoints) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList());
        }

        private EndpointServerWebExchangeMatcher(String[] endpoints) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList());
        }

        private EndpointServerWebExchangeMatcher(List<Object> includes, List<Object> excludes) {
            super(PathMappedEndpoints.class);
            this.includes = includes;
            this.excludes = excludes;
        }

        EndpointServerWebExchangeMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointServerWebExchangeMatcher(this.includes, excludes);
        }

        EndpointServerWebExchangeMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointServerWebExchangeMatcher(this.includes, excludes);
        }

        protected void initialized(Supplier<PathMappedEndpoints> pathMappedEndpoints) {
            this.delegate = this.createDelegate(pathMappedEndpoints);
        }

        private ServerWebExchangeMatcher createDelegate(Supplier<PathMappedEndpoints> pathMappedEndpoints) {
            try {
                return this.createDelegate(pathMappedEndpoints.get());
            }
            catch (NoSuchBeanDefinitionException ex) {
                return EMPTY_MATCHER;
            }
        }

        private ServerWebExchangeMatcher createDelegate(PathMappedEndpoints pathMappedEndpoints) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(pathMappedEndpoints.getAllPaths());
            }
            this.streamPaths(this.includes, pathMappedEndpoints).forEach(paths::add);
            this.streamPaths(this.excludes, pathMappedEndpoints).forEach(paths::remove);
            return new OrServerWebExchangeMatcher(this.getDelegateMatchers(paths));
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints pathMappedEndpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(arg_0 -> ((PathMappedEndpoints)pathMappedEndpoints).getPath(arg_0));
        }

        private String getEndpointId(Object source) {
            if (source instanceof String) {
                return (String)source;
            }
            if (source instanceof Class) {
                return this.getEndpointId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + source);
        }

        private String getEndpointId(Class<?> source) {
            Endpoint annotation = (Endpoint)AnnotationUtils.findAnnotation(source, Endpoint.class);
            Assert.state((annotation != null ? 1 : 0) != 0, () -> "Class " + source + " is not annotated with @Endpoint");
            return annotation.id();
        }

        private List<ServerWebExchangeMatcher> getDelegateMatchers(Set<String> paths) {
            return paths.stream().map(path -> new PathPatternParserServerWebExchangeMatcher(path + "/**")).collect(Collectors.toList());
        }

        protected Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange, Supplier<PathMappedEndpoints> context) {
            return this.delegate.matches(exchange);
        }
    }
}

