/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimplePropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@EnableConfigurationProperties(value={SimpleProperties.class})
@ConditionalOnMissingBean(value={MeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.simple", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SimpleMetricsExportAutoConfiguration {
    @Bean
    public SimpleMeterRegistry simpleMeterRegistry(SimpleConfig config, Clock clock) {
        return new SimpleMeterRegistry(config, clock);
    }

    @Bean
    @ConditionalOnMissingBean(value={SimpleConfig.class})
    public SimpleConfig simpleConfig(SimpleProperties simpleProperties) {
        return new SimplePropertiesConfigAdapter(simpleProperties);
    }
}

