/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.aether.graph.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;

public class PathResolver {
    private static final Logger log = LoggerFactory.getLogger(PathResolver.class);
    private final DependencyResolver engine;
    private ResourceLoader resources = new DefaultResourceLoader();
    private String[] locations = new String[]{"classpath:/", "file:."};
    private String root;
    private Properties overrides = new Properties();
    private boolean offline;

    public PathResolver(DependencyResolver engine) {
        this.engine = engine;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setOverrides(Properties overrides) {
        this.overrides = overrides;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public List<Archive> resolve(Archive archive, String name, String ... profiles) {
        return this.resolve(null, archive, name, profiles);
    }

    public List<Archive> resolve(Archive parent, Archive archive, String name, String ... profiles) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (parent != null) {
            archives.addAll(this.archives(this.extract(parent, archive, name, profiles)));
        } else {
            archives.addAll(this.archives(this.extract(archive, name, profiles)));
        }
        this.addRootArchive(archives, archive);
        return archives;
    }

    public Resource getPom(Archive archive) {
        String artifactId;
        UrlResource pom;
        try {
            pom = new UrlResource(archive.getUrl() + "pom.xml");
            artifactId = this.extractArtifactId(archive);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot locate archive", e);
        }
        if (!pom.exists()) {
            String pattern = "META-INF/maven/**" + (artifactId == null ? "" : "/" + artifactId) + "/pom.xml";
            Resource resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
            pattern = "BOOT-INF/classes/META-INF/maven/**" + (artifactId == null ? "" : "/" + artifactId) + "/pom.xml";
            resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
            pattern = "META-INF/maven/**/pom.xml";
            resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
            pattern = "**/META-INF/maven/**/pom.xml";
            resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
        }
        if (!pom.exists()) {
            pom = new ClassPathResource("META-INF/thin/empty-pom.xml");
        }
        return pom;
    }

    private void addRootArchive(List<Archive> archives, Archive archive) {
        if (!archives.isEmpty()) {
            archives.add(0, archive);
        } else {
            archives.add(archive);
        }
    }

    private List<Dependency> extract(Archive parent, Archive archive, String name, String[] profiles) {
        Properties properties = this.getProperties(archive, name, profiles);
        Resource parentPom = this.getPom(parent);
        List<Dependency> parentDependencies = this.engine.dependencies(parentPom, properties);
        Resource childPom = this.getPom(archive);
        List<Dependency> childDependencies = this.engine.dependencies(childPom, properties);
        HashMap<String, Dependency> lookup = new HashMap<String, Dependency>();
        for (Dependency dependency : parentDependencies) {
            lookup.put(this.coordinates(dependency), dependency);
        }
        for (Dependency dependency : childDependencies) {
            if (lookup.containsKey(this.coordinates(dependency))) continue;
            parentDependencies.add(dependency);
        }
        return parentDependencies;
    }

    private String coordinates(Dependency dependency) {
        return dependency.getArtifact().getGroupId() + ":" + dependency.getArtifact().getArtifactId();
    }

    public List<Dependency> extract(Archive archive, String name, String[] profiles) {
        Properties properties = this.getProperties(archive, name, profiles);
        Resource pom = this.getPom(archive);
        log.info("Extracting dependencies from: {}", (Object)pom);
        return this.engine.dependencies(pom, properties);
    }

    private Properties getProperties(Archive archive, String name, String[] profiles) {
        Properties properties = new Properties();
        this.loadThinProperties(properties, archive, name, profiles);
        this.loadThinProperties(properties, this.locations, name, profiles);
        if (this.root != null) {
            properties.setProperty("thin.root", this.root);
        }
        if (this.offline) {
            properties.setProperty("thin.offline", "true");
        }
        this.addOverrideProperties(properties);
        return properties;
    }

    private void addOverrideProperties(Properties properties) {
        properties.putAll((Map<?, ?>)this.overrides);
    }

    private Properties loadThinProperties(Properties props, Archive archive, String name, String[] list) {
        ArrayList<String> profiles = new ArrayList<String>(Arrays.asList(list));
        if (!profiles.contains("")) {
            profiles.add(0, "");
        }
        for (String profile : profiles) {
            String path = name + ("".equals(profile) ? "" : "-") + profile + ".properties";
            this.loadProperties(props, archive, path);
        }
        return props;
    }

    private void loadThinProperties(Properties props, String[] locations, String name, String[] profiles) {
        for (String profile : profiles) {
            String path = name + ("".equals(profile) ? "" : "-") + profile + ".properties";
            for (String location : locations) {
                try {
                    if (!location.endsWith("/")) {
                        location = location + "/";
                    }
                    this.loadProperties(props, location, path);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot load properties", e);
                }
            }
        }
    }

    private void loadProperties(Properties props, Archive archive, String path) {
        try {
            this.loadProperties(props, archive.getUrl().toString(), path);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load properties", e);
        }
    }

    private Properties loadProperties(Properties props, String url, String path) {
        log.info("Searching for properties in: " + url);
        Properties added = new Properties();
        try {
            Resource resource = this.resources.getResource(url).createRelative("META-INF/" + path);
            if (resource.exists()) {
                log.info("Loading properties from: " + resource);
                PropertiesLoaderUtils.fillProperties((Properties)added, (Resource)resource);
            }
            if ((resource = this.resources.getResource(url).createRelative("/" + path)).exists()) {
                log.info("Loading properties from: " + resource);
                PropertiesLoaderUtils.fillProperties((Properties)added, (Resource)resource);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load properties", e);
        }
        this.merge(props, added);
        return props;
    }

    private void merge(Properties props, Properties added) {
        if ("true".equals(props.get("computed"))) {
            if (!"true".equals(added.get("computed"))) {
                for (Object key : added.keySet()) {
                    String name = (String)key;
                    if (!name.startsWith("dependencies.") && !name.startsWith("boms.")) continue;
                    added.remove(key);
                }
            }
        } else if ("true".equals(added.get("computed"))) {
            for (Object key : props.keySet()) {
                String name = (String)key;
                if (!name.startsWith("dependencies.") && !name.startsWith("boms.")) continue;
                props.remove(key);
            }
        }
        props.putAll((Map<?, ?>)added);
    }

    private List<Archive> archives(List<Dependency> dependencies) {
        ArrayList<Archive> list = new ArrayList<Archive>();
        for (Dependency dependency : dependencies) {
            File file = dependency.getArtifact().getFile();
            if (file == null) continue;
            try {
                list.add((Archive)new JarFileArchive(file, file.toURI().toURL()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot locate archive", e);
            }
        }
        return list;
    }

    private Resource findResource(Archive archive, String pattern) {
        try {
            for (Resource resource : ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)new DefaultResourceLoader()).getResources(archive.getUrl() + pattern)) {
                if (!resource.exists()) continue;
                return resource;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String extractArtifactId(Archive archive) throws MalformedURLException {
        String path = archive.getUrl().getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - 2);
        }
        path = StringUtils.getFilename((String)path);
        path = path.split("-[0-9]")[0];
        return path;
    }
}

