/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.guice.AetherModule;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.plexus.ClassRealmManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.thin.CompositeProxySelector;
import org.springframework.boot.loader.thin.DependencyResolutionModule;
import org.springframework.boot.loader.thin.MavenSettings;
import org.springframework.boot.loader.thin.MavenSettingsReader;
import org.springframework.boot.loader.thin.ThinPropertiesModelProcessor;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class DependencyResolver {
    private static final Logger log = LoggerFactory.getLogger(DependencyResolver.class);
    private static DependencyResolver instance = new DependencyResolver();
    private static Properties globals;
    private LocalRepositoryManagerFactory localRepositoryManagerFactory;
    private PlexusContainer container;
    private Object lock = new Object();
    private ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private MavenSettings settings;

    public static DependencyResolver instance() {
        return instance;
    }

    public static void close() {
        instance = new DependencyResolver();
    }

    private DependencyResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.container == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.container == null) {
                    DefaultPlexusContainer container;
                    ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
                    ContainerConfiguration config = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classWorld.getClassRealm("plexus.core")).setClassPathScanning("index").setAutoWiring(true).setName("maven");
                    try {
                        container = new DefaultPlexusContainer(config, new Module[]{new AetherModule(), new DependencyResolutionModule()});
                        this.localRepositoryManagerFactory = (LocalRepositoryManagerFactory)container.lookup(LocalRepositoryManagerFactory.class);
                        container.addComponent((Object)new ClassRealmManager((MutablePlexusContainer)container, (MutableBeanLocator)new DefaultBeanLocator()), ClassRealmManager.class.getName());
                        this.projectBuilder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
                        this.repositorySystem = (RepositorySystem)container.lookup(RepositorySystem.class);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create container", e);
                    }
                    this.container = container;
                    this.settings = new MavenSettingsReader().readSettings();
                }
            }
        }
    }

    public List<Dependency> dependencies(Resource resource) {
        return this.dependencies(resource, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dependency> dependencies(Resource resource, Properties properties) {
        if ("true".equals(properties.getProperty("computed", "false"))) {
            log.info("Dependencies are pre-computed in properties");
            Model model = new Model();
            model = ThinPropertiesModelProcessor.process(model, properties);
            return this.aetherDependencies(model.getDependencies());
        }
        this.initialize();
        try {
            log.info("Computing dependencies from pom and properties");
            ProjectBuildingRequest request = this.getProjectBuildingRequest(properties);
            request.setResolveDependencies(true);
            Class<DependencyResolver> clazz = DependencyResolver.class;
            synchronized (DependencyResolver.class) {
                ProjectBuildingResult result = this.projectBuilder.build((ModelSource)new PropertiesModelSource(properties, resource), request);
                globals = null;
                DependencyResolutionResult dependencies = result.getDependencyResolutionResult();
                if (!dependencies.getUnresolvedDependencies().isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    for (Dependency dependency : dependencies.getUnresolvedDependencies()) {
                        List errors = dependencies.getResolutionErrors(dependency);
                        for (Exception exception : errors) {
                            if (builder.length() > 0) {
                                builder.append("\n");
                            }
                            builder.append(exception.getMessage());
                        }
                    }
                    throw new RuntimeException(builder.toString());
                }
                List<Dependency> output = this.runtime(dependencies.getDependencies());
                if (log.isInfoEnabled()) {
                    for (Dependency dependency : output) {
                        log.info("Resolved: " + this.coordinates(dependency) + "=" + dependency.getArtifact().getFile());
                    }
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return output;
            }
        }
        catch (ProjectBuildingException | NoLocalRepositoryManagerException e) {
            throw new IllegalStateException("Cannot build model", e);
        }
    }

    private List<Dependency> aetherDependencies(List<org.apache.maven.model.Dependency> dependencies) {
        ArrayList<Object> list = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency dependency : dependencies) {
            DefaultArtifact artifact = new DefaultArtifact(this.coordinates(dependency));
            Dependency converted = new Dependency((Artifact)artifact, "runtime");
            list.add(converted);
        }
        this.initialize();
        List<ArtifactResult> result = this.collectNonTransitive(list);
        list = new ArrayList();
        for (ArtifactResult item : result) {
            Artifact artifact = item.getArtifact();
            Dependency converted = new Dependency(artifact, "runtime");
            list.add(converted);
        }
        return list;
    }

    private String coordinates(org.apache.maven.model.Dependency artifact) {
        String classifier = artifact.getClassifier();
        String extension = artifact.getType();
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (extension != null ? ":" + extension : "") + (classifier != null ? ":" + classifier : "") + ":" + artifact.getVersion();
    }

    private String coordinates(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        if ("jar".equals(extension) && !StringUtils.hasText((String)classifier)) {
            extension = null;
        }
        boolean hasExtension = extension != null && !"jar".equals(extension);
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (hasExtension ? ":" + extension : "") + (StringUtils.hasText((String)classifier) ? ":" + classifier : "") + ":" + artifact.getVersion();
    }

    public File resolve(Dependency dependency) {
        this.initialize();
        return this.collectNonTransitive(Arrays.asList(dependency)).iterator().next().getArtifact().getFile();
    }

    private List<Dependency> runtime(List<Dependency> dependencies) {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if ("test".equals(dependency.getScope()) || "provided".equals(dependency.getScope())) continue;
            list.add(dependency);
        }
        return list;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(Properties properties) throws NoLocalRepositoryManagerException {
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        DefaultRepositorySystemSession session = this.createSession(properties);
        projectBuildingRequest.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
        projectBuildingRequest.setRemoteRepositories(this.mavenRepositories(this.settings, session, properties));
        projectBuildingRequest.getRemoteRepositories().addAll(this.mavenRepositories(this.settings, session));
        projectBuildingRequest.setRepositorySession((RepositorySystemSession)session);
        projectBuildingRequest.setProcessPlugins(false);
        projectBuildingRequest.setBuildStartTime(new Date());
        projectBuildingRequest.setUserProperties(properties);
        projectBuildingRequest.setSystemProperties(System.getProperties());
        return projectBuildingRequest;
    }

    private Collection<? extends ArtifactRepository> mavenRepositories(MavenSettings settings, DefaultRepositorySystemSession session) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        for (Profile profile : settings.getActiveProfiles()) {
            for (Repository repository : profile.getRepositories()) {
                this.addRepositoryIfMissing(settings, session, list, repository.getId(), repository.getUrl(), repository.getReleases() != null ? repository.getReleases().isEnabled() : true, repository.getSnapshots() != null ? repository.getSnapshots().isEnabled() : false);
            }
        }
        return list;
    }

    private List<ArtifactRepository> mavenRepositories(MavenSettings settings, DefaultRepositorySystemSession session, Properties properties) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        if (properties.containsKey("thin.root")) {
            this.addRepositoryIfMissing(settings, session, list, "local", "file://" + this.getM2RepoDirectory(), true, true);
        }
        this.addRepositoryIfMissing(settings, session, list, "spring-snapshots", "https://repo.spring.io/libs-snapshot", true, true);
        this.addRepositoryIfMissing(settings, session, list, "central", "https://repo1.maven.org/maven2", true, false);
        return list;
    }

    private List<RemoteRepository> aetherRepositories(MavenSettings settings, DefaultRepositorySystemSession session, Properties properties) {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        for (ArtifactRepository input : this.mavenRepositories(settings, session, properties)) {
            list.add(this.remote(input));
        }
        return list;
    }

    private RemoteRepository remote(ArtifactRepository input) {
        return new RemoteRepository.Builder(input.getId(), input.getLayout().getId(), input.getUrl()).setSnapshotPolicy(this.policy(input.getSnapshots())).setReleasePolicy(this.policy(input.getReleases())).build();
    }

    private RepositoryPolicy policy(ArtifactRepositoryPolicy input) {
        RepositoryPolicy policy = new RepositoryPolicy(input.isEnabled(), "daily", "warn");
        return policy;
    }

    private void addRepositoryIfMissing(MavenSettings settings, DefaultRepositorySystemSession session, List<ArtifactRepository> list, String id, String url, boolean releases, boolean snapshots) {
        for (ArtifactRepository repo : list) {
            if (url.equals(repo.getUrl())) {
                return;
            }
            if (!id.equals(repo.getId())) continue;
            return;
        }
        list.add(this.repo(settings, session, id, url, releases, snapshots));
    }

    private ArtifactRepository repo(MavenSettings settings, DefaultRepositorySystemSession session, String id, String url, boolean releases, boolean snapshots) {
        MavenArtifactRepository repository = new MavenArtifactRepository();
        repository.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        repository.setId(id);
        repository.setUrl(url);
        ArtifactRepositoryPolicy enabled = new ArtifactRepositoryPolicy();
        enabled.setEnabled(true);
        ArtifactRepositoryPolicy disabled = new ArtifactRepositoryPolicy();
        disabled.setEnabled(false);
        repository.setReleaseUpdatePolicy(releases ? enabled : disabled);
        repository.setSnapshotUpdatePolicy(snapshots ? enabled : disabled);
        RemoteRepository remote = new RemoteRepository.Builder(id, null, url).build();
        Authentication authentication = settings.getAuthenticationSelector().getAuthentication(remote);
        if (authentication != null) {
            remote = new RemoteRepository.Builder(remote).setAuthentication(authentication).build();
            repository.setAuthentication(this.authentication(settings, (RepositorySystemSession)session, remote, authentication));
        }
        return repository;
    }

    private org.apache.maven.artifact.repository.Authentication authentication(MavenSettings settings, RepositorySystemSession session, RemoteRepository remote, Authentication authentication) {
        AuthenticationContext context = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)remote);
        if (context == null) {
            return null;
        }
        authentication.fill(context, "username", Collections.emptyMap());
        authentication.fill(context, "password", Collections.emptyMap());
        authentication.fill(context, "passphrase", Collections.emptyMap());
        authentication.fill(context, "privateKey", Collections.emptyMap());
        org.apache.maven.artifact.repository.Authentication maven = new org.apache.maven.artifact.repository.Authentication(context.get("username"), context.get("password"));
        if (context.get("passphrase") != null) {
            maven.setPassphrase(context.get("passphrase"));
        }
        if (context.get("privateKey") != null) {
            maven.setPrivateKey(context.get("privateKey"));
        }
        return maven;
    }

    private DefaultRepositorySystemSession createSession(Properties properties) throws NoLocalRepositoryManagerException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repository = this.localRepository(properties);
        session.setLocalRepositoryManager(this.localRepositoryManagerFactory.newInstance((RepositorySystemSession)session, repository));
        this.applySettings(session);
        ProxySelector existing = session.getProxySelector();
        if (existing == null || !(existing instanceof CompositeProxySelector)) {
            JreProxySelector fallback = new JreProxySelector();
            Object selector = existing == null ? fallback : new CompositeProxySelector(Arrays.asList(existing, fallback));
            session.setProxySelector((ProxySelector)selector);
        }
        if (properties.containsKey("thin.offline") && !"false".equals(properties.getProperty("thin.offline"))) {
            session.setOffline(true);
        }
        return session;
    }

    private void applySettings(DefaultRepositorySystemSession session) {
        MavenSettingsReader.applySettings(this.settings, session);
    }

    private LocalRepository localRepository(Properties properties) {
        if (!properties.containsKey("thin.root")) {
            return new LocalRepository(this.getM2RepoDirectory());
        }
        String root = properties.getProperty("thin.root");
        return new LocalRepository(StringUtils.cleanPath((String)(root + "/repository")));
    }

    public Model readModel(Resource resource) {
        return this.readModel(resource, new Properties());
    }

    public Model readModel(Resource resource, Properties properties) {
        this.initialize();
        try {
            ProjectBuildingRequest request = this.getProjectBuildingRequest(properties);
            request.setResolveDependencies(false);
            ProjectBuildingResult result = this.projectBuilder.build((ModelSource)new PropertiesModelSource(properties, resource), request);
            return result.getProject().getModel();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build model from effective pom", e);
        }
    }

    private File getM2RepoDirectory() {
        return new File(this.getDefaultM2HomeDirectory(), "repository");
    }

    private File getDefaultM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength((String)mavenRoot)) {
            return new File(mavenRoot);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }

    private List<ArtifactResult> collectNonTransitive(List<Dependency> dependencies) {
        try {
            List<ArtifactRequest> artifactRequests = this.getArtifactRequests(dependencies);
            List result = this.repositorySystem.resolveArtifacts((RepositorySystemSession)this.createSession(new Properties()), artifactRequests);
            return result;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private List<ArtifactRequest> getArtifactRequests(List<Dependency> dependencies) {
        ArrayList<ArtifactRequest> list = new ArrayList<ArtifactRequest>();
        for (Dependency dependency : dependencies) {
            ArtifactRequest request = new ArtifactRequest(dependency.getArtifact(), null, null);
            try {
                DefaultRepositorySystemSession session = this.createSession(new Properties());
                request.setRepositories(this.aetherRepositories(this.settings, session, new Properties()));
            }
            catch (NoLocalRepositoryManagerException e) {
                throw new IllegalStateException("No local repository manager", e);
            }
            list.add(request);
        }
        return list;
    }

    static Properties getGlobals() {
        return globals;
    }

    private static final class PropertiesModelSource
    implements ModelSource {
        private final Properties properties;
        private final Resource resource;

        private PropertiesModelSource(Properties properties, Resource resource) {
            this.properties = properties;
            this.resource = resource;
        }

        public InputStream getInputStream() throws IOException {
            globals = this.properties;
            return new BufferedInputStream(this.resource.getInputStream()){

                @Override
                public void close() throws IOException {
                    globals = null;
                    super.close();
                }
            };
        }

        public String getLocation() {
            return this.resource.getDescription();
        }
    }
}

