/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class Layer {
    private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z0-9-]+$");
    private final String name;

    public Layer(String name) {
        Assert.hasText(name, "Name must not be empty");
        Assert.isTrue(PATTERN.matcher(name).matches(), () -> "Malformed layer name '" + name + "'");
        Assert.isTrue(!name.equalsIgnoreCase("ext") && !name.toLowerCase().startsWith("springboot"), () -> "Layer name '" + name + "' is reserved");
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((Layer)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

