/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Packager;
import org.springframework.util.Assert;

public class ImagePackager
extends Packager {
    public ImagePackager(File source) {
        super(source, null);
    }

    public void packageImage(Libraries libraries, BiConsumer<ZipEntry, EntryWriter> exporter) throws IOException {
        this.packageImage(libraries, new DelegatingJarWriter(exporter));
    }

    private void packageImage(Libraries libraries, AbstractJarWriter writer) throws IOException {
        File source = this.isAlreadyPackaged() ? this.getBackupFile() : this.getSource();
        Assert.state(source.exists() && source.isFile(), () -> "Unable to read jar file " + source);
        Assert.state(!this.isAlreadyPackaged(source), () -> "Repackaged jar file " + source + " cannot be exported");
        try (JarFile sourceJar = new JarFile(source);){
            this.write(sourceJar, libraries, writer);
        }
    }

    private static class DelegatingJarWriter
    extends AbstractJarWriter {
        private BiConsumer<ZipEntry, EntryWriter> exporter;

        DelegatingJarWriter(BiConsumer<ZipEntry, EntryWriter> exporter) {
            this.exporter = exporter;
        }

        @Override
        protected void writeToArchive(ZipEntry entry, EntryWriter entryWriter) throws IOException {
            this.exporter.accept(entry, entryWriter);
        }
    }
}

