/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.LocalRepositoryManager;
import hidden.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import hidden.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public SimpleLocalRepositoryManagerFactory() {
    }

    @Inject
    SimpleLocalRepositoryManagerFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "simple".equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasedir()).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public SimpleLocalRepositoryManagerFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, SimpleLocalRepositoryManager.class);
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public SimpleLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

