/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.shared.utils.logging;

import hidden.org.apache.maven.shared.utils.logging.AnsiMessageBuilder;
import hidden.org.apache.maven.shared.utils.logging.LoggerLevelRenderer;
import hidden.org.apache.maven.shared.utils.logging.MessageBuilder;
import hidden.org.apache.maven.shared.utils.logging.PlainMessageBuilder;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class MessageUtils {
    private static final boolean JANSI;
    private static Thread shutdownHook;
    private static final Object STARTUP_SHUTDOWN_MONITOR;

    public static void systemInstall() {
        if (JANSI) {
            AnsiConsole.systemInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemUninstall() {
        Object object = STARTUP_SHUTDOWN_MONITOR;
        synchronized (object) {
            MessageUtils.doSystemUninstall();
            if (shutdownHook != null && AnsiConsole.out == AnsiConsole.system_out) {
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private static void doSystemUninstall() {
        if (JANSI) {
            AnsiConsole.systemUninstall();
        }
    }

    public static void setColorEnabled(boolean flag) {
        if (JANSI) {
            Ansi.setEnabled((boolean)flag);
        }
    }

    public static boolean isColorEnabled() {
        return JANSI ? Ansi.isEnabled() : false;
    }

    public static MessageBuilder buffer() {
        return (MessageBuilder)((Object)(JANSI ? new AnsiMessageBuilder() : new PlainMessageBuilder()));
    }

    public static MessageBuilder buffer(StringBuilder builder) {
        return (MessageBuilder)((Object)(JANSI ? new AnsiMessageBuilder(builder) : new PlainMessageBuilder(builder)));
    }

    public static MessageBuilder buffer(int size) {
        return (MessageBuilder)((Object)(JANSI ? new AnsiMessageBuilder(size) : new PlainMessageBuilder(size)));
    }

    public static LoggerLevelRenderer level() {
        return JANSI ? new AnsiMessageBuilder(20) : new PlainMessageBuilder(7);
    }

    public static String stripAnsiCodes(String msg) {
        return msg.replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", "");
    }

    public static void registerShutdownHook() {
        if (JANSI && shutdownHook == null) {
            shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = STARTUP_SHUTDOWN_MONITOR;
                    synchronized (object) {
                        MessageUtils.doSystemUninstall();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    static {
        STARTUP_SHUTDOWN_MONITOR = new Object();
        boolean jansi = true;
        try {
            Class.forName("org.fusesource.jansi.Ansi");
        }
        catch (ClassNotFoundException cnfe) {
            jansi = false;
        }
        JANSI = jansi;
    }
}

