/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository.internal;

import hidden.org.apache.maven.artifact.repository.metadata.Snapshot;
import hidden.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import hidden.org.apache.maven.artifact.repository.metadata.Versioning;
import hidden.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import hidden.org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import hidden.org.eclipse.aether.RepositoryCache;
import hidden.org.eclipse.aether.RepositoryEvent;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.SyncContext;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.impl.MetadataResolver;
import hidden.org.eclipse.aether.impl.RepositoryEventDispatcher;
import hidden.org.eclipse.aether.impl.SyncContextFactory;
import hidden.org.eclipse.aether.impl.VersionResolver;
import hidden.org.eclipse.aether.internal.impl.CacheUtils;
import hidden.org.eclipse.aether.metadata.DefaultMetadata;
import hidden.org.eclipse.aether.metadata.Metadata;
import hidden.org.eclipse.aether.repository.ArtifactRepository;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.repository.WorkspaceReader;
import hidden.org.eclipse.aether.repository.WorkspaceRepository;
import hidden.org.eclipse.aether.resolution.MetadataRequest;
import hidden.org.eclipse.aether.resolution.MetadataResult;
import hidden.org.eclipse.aether.resolution.VersionRequest;
import hidden.org.eclipse.aether.resolution.VersionResolutionException;
import hidden.org.eclipse.aether.resolution.VersionResult;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import hidden.org.eclipse.aether.util.ConfigUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.Validate;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultVersionResolver
implements VersionResolver,
Service {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT = "SNAPSHOT";
    private Logger logger = NullLoggerFactory.LOGGER;
    private MetadataResolver metadataResolver;
    private SyncContextFactory syncContextFactory;
    private RepositoryEventDispatcher repositoryEventDispatcher;

    public DefaultVersionResolver() {
    }

    @Inject
    DefaultVersionResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setMetadataResolver(metadataResolver);
        this.setSyncContextFactory(syncContextFactory);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultVersionResolver setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultVersionResolver setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Validate.notNull(metadataResolver, "metadataResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultVersionResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Validate.notNull(syncContextFactory, "syncContextFactory cannot be null", new Object[0]);
        return this;
    }

    public DefaultVersionResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Validate.notNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null", new Object[0]);
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        DefaultMetadata metadata;
        Object obj;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        Artifact artifact = request.getArtifact();
        String version = artifact.getVersion();
        VersionResult result = new VersionResult(request);
        Key cacheKey = null;
        RepositoryCache cache = session.getCache();
        if (cache != null && !ConfigUtils.getBoolean(session, false, "aether.versionResolver.noCache") && (obj = cache.get(session, cacheKey = new Key(session, request))) instanceof Record) {
            Record record = (Record)obj;
            result.setVersion(record.version);
            result.setRepository(CacheUtils.getRepository(session, request.getRepositories(), record.repoClass, record.repoId));
            return result;
        }
        if (RELEASE.equals(version)) {
            metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE);
        } else if (LATEST.equals(version)) {
            metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        } else if (version.endsWith(SNAPSHOT)) {
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace != null && workspace.findVersions(artifact).contains(version)) {
                metadata = null;
                result.setRepository(workspace.getRepository());
            } else {
                metadata = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), version, MAVEN_METADATA_XML, Metadata.Nature.SNAPSHOT);
            }
        } else {
            metadata = null;
        }
        if (metadata == null) {
            result.setVersion(version);
        } else {
            ArrayList<Object> metadataReqs = new ArrayList<Object>(request.getRepositories().size());
            metadataReqs.add(new MetadataRequest(metadata, null, request.getRequestContext()));
            for (RemoteRepository repository : request.getRepositories()) {
                MetadataRequest metadataRequest = new MetadataRequest(metadata, repository, request.getRequestContext());
                metadataRequest.setDeleteLocalCopyIfMissing(true);
                metadataRequest.setFavorLocalRepository(true);
                metadataRequest.setTrace(trace);
                metadataReqs.add(metadataRequest);
            }
            List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session, metadataReqs);
            HashMap<String, VersionInfo> infos = new HashMap<String, VersionInfo>();
            for (MetadataResult metadataResult : metadataResults) {
                result.addException(metadataResult.getException());
                ArtifactRepository repository = metadataResult.getRequest().getRepository();
                if (repository == null) {
                    repository = session.getLocalRepository();
                }
                Versioning v = this.readVersions(session, trace, metadataResult.getMetadata(), repository, result);
                this.merge(artifact, infos, v, repository);
            }
            if (RELEASE.equals(version)) {
                this.resolve(result, infos, RELEASE);
            } else if (LATEST.equals(version)) {
                if (!this.resolve(result, infos, LATEST)) {
                    this.resolve(result, infos, RELEASE);
                }
                if (result.getVersion() != null && result.getVersion().endsWith(SNAPSHOT)) {
                    VersionRequest subRequest = new VersionRequest();
                    subRequest.setArtifact(artifact.setVersion(result.getVersion()));
                    if (result.getRepository() instanceof RemoteRepository) {
                        RemoteRepository r = (RemoteRepository)result.getRepository();
                        subRequest.setRepositories(Collections.singletonList(r));
                    } else {
                        subRequest.setRepositories(request.getRepositories());
                    }
                    VersionResult subResult = this.resolveVersion(session, subRequest);
                    result.setVersion(subResult.getVersion());
                    result.setRepository(subResult.getRepository());
                    for (Exception exception : subResult.getExceptions()) {
                        result.addException(exception);
                    }
                }
            } else {
                String key = SNAPSHOT + this.getKey(artifact.getClassifier(), artifact.getExtension());
                this.merge(infos, SNAPSHOT, key);
                if (!this.resolve(result, infos, key)) {
                    result.setVersion(version);
                }
            }
            if (StringUtils.isEmpty(result.getVersion())) {
                throw new VersionResolutionException(result);
            }
        }
        if (cacheKey != null && metadata != null && this.isSafelyCacheable(session, artifact)) {
            cache.put(session, cacheKey, new Record(result.getVersion(), result.getRepository()));
        }
        return result;
    }

    private boolean resolve(VersionResult result, Map<String, VersionInfo> infos, String key) {
        VersionInfo info = infos.get(key);
        if (info != null) {
            result.setVersion(info.version);
            result.setRepository(info.repository);
        }
        return info != null;
    }

    private Versioning readVersions(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, VersionResult result) {
        Versioning versioning;
        block27: {
            versioning = null;
            try {
                if (metadata == null) break block27;
                try (SyncContext syncContext = this.syncContextFactory.newInstance(session, true);){
                    syncContext.acquire(null, Collections.singleton(metadata));
                    if (metadata.getFile() == null || !metadata.getFile().exists()) break block27;
                    try (FileInputStream in = new FileInputStream(metadata.getFile());){
                        versioning = new MetadataXpp3Reader().read(in, false).getVersioning();
                        if (versioning != null && repository instanceof LocalRepository && versioning.getSnapshot() != null && versioning.getSnapshot().getBuildNumber() > 0) {
                            Versioning repaired = new Versioning();
                            repaired.setLastUpdated(versioning.getLastUpdated());
                            repaired.setSnapshot(new Snapshot());
                            repaired.getSnapshot().setLocalCopy(true);
                            versioning = repaired;
                            throw new IOException("Snapshot information corrupted with remote repository data, please verify that no remote repository uses the id '" + repository.getId() + "'");
                        }
                    }
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session, trace, metadata, repository, e);
                result.addException(e);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void merge(Artifact artifact, Map<String, VersionInfo> infos, Versioning versioning, ArtifactRepository repository) {
        if (StringUtils.isNotEmpty(versioning.getRelease())) {
            this.merge(RELEASE, infos, versioning.getLastUpdated(), versioning.getRelease(), repository);
        }
        if (StringUtils.isNotEmpty(versioning.getLatest())) {
            this.merge(LATEST, infos, versioning.getLastUpdated(), versioning.getLatest(), repository);
        }
        for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
            if (!StringUtils.isNotEmpty(sv.getVersion())) continue;
            String key = this.getKey(sv.getClassifier(), sv.getExtension());
            this.merge(SNAPSHOT + key, infos, sv.getUpdated(), sv.getVersion(), repository);
        }
        Snapshot snapshot = versioning.getSnapshot();
        if (snapshot != null && versioning.getSnapshotVersions().isEmpty()) {
            String version = artifact.getVersion();
            if (snapshot.getTimestamp() != null && snapshot.getBuildNumber() > 0) {
                String qualifier = snapshot.getTimestamp() + '-' + snapshot.getBuildNumber();
                version = version.substring(0, version.length() - SNAPSHOT.length()) + qualifier;
            }
            this.merge(SNAPSHOT, infos, versioning.getLastUpdated(), version, repository);
        }
    }

    private void merge(String key, Map<String, VersionInfo> infos, String timestamp, String version, ArtifactRepository repository) {
        VersionInfo info = infos.get(key);
        if (info == null) {
            info = new VersionInfo(timestamp, version, repository);
            infos.put(key, info);
        } else if (info.isOutdated(timestamp)) {
            info.version = version;
            info.repository = repository;
            info.timestamp = timestamp;
        }
    }

    private void merge(Map<String, VersionInfo> infos, String srcKey, String dstKey) {
        VersionInfo srcInfo = infos.get(srcKey);
        VersionInfo dstInfo = infos.get(dstKey);
        if (dstInfo == null || srcInfo != null && dstInfo.isOutdated(srcInfo.timestamp) && srcInfo.repository != dstInfo.repository) {
            infos.put(dstKey, srcInfo);
        }
    }

    private String getKey(String classifier, String extension) {
        return StringUtils.clean(classifier) + ':' + StringUtils.clean(extension);
    }

    private boolean isSafelyCacheable(RepositorySystemSession session, Artifact artifact) {
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace == null) {
            return true;
        }
        Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(artifact);
        return workspace.findArtifact(pomArtifact) == null;
    }

    private static class Record {
        final String version;
        final String repoId;
        final Class<?> repoClass;

        Record(String version, ArtifactRepository repository) {
            this.version = version;
            if (repository != null) {
                this.repoId = repository.getId();
                this.repoClass = repository.getClass();
            } else {
                this.repoId = null;
                this.repoClass = null;
            }
        }
    }

    private static class Key {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String extension;
        private final String version;
        private final String context;
        private final File localRepo;
        private final WorkspaceRepository workspace;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        Key(RepositorySystemSession session, VersionRequest request) {
            Artifact artifact = request.getArtifact();
            this.groupId = artifact.getGroupId();
            this.artifactId = artifact.getArtifactId();
            this.classifier = artifact.getClassifier();
            this.extension = artifact.getExtension();
            this.version = artifact.getVersion();
            this.localRepo = session.getLocalRepository().getBasedir();
            this.workspace = CacheUtils.getWorkspace(session);
            this.repositories = new ArrayList<RemoteRepository>(request.getRepositories().size());
            boolean repoMan = false;
            for (RemoteRepository repository : request.getRepositories()) {
                if (repository.isRepositoryManager()) {
                    repoMan = true;
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.context = repoMan ? request.getRequestContext() : "";
            int hash = 17;
            hash = hash * 31 + this.groupId.hashCode();
            hash = hash * 31 + this.artifactId.hashCode();
            hash = hash * 31 + this.classifier.hashCode();
            hash = hash * 31 + this.extension.hashCode();
            hash = hash * 31 + this.version.hashCode();
            hash = hash * 31 + this.localRepo.hashCode();
            this.hashCode = hash = hash * 31 + CacheUtils.repositoriesHashCode(this.repositories);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.classifier.equals(that.classifier) && this.extension.equals(that.extension) && this.version.equals(that.version) && this.context.equals(that.context) && this.localRepo.equals(that.localRepo) && CacheUtils.eq(this.workspace, that.workspace) && CacheUtils.repositoriesEquals(this.repositories, that.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class VersionInfo {
        String timestamp;
        String version;
        ArtifactRepository repository;

        VersionInfo(String timestamp, String version, ArtifactRepository repository) {
            this.timestamp = timestamp != null ? timestamp : "";
            this.version = version;
            this.repository = repository;
        }

        boolean isOutdated(String timestamp) {
            return timestamp != null && timestamp.compareTo(this.timestamp) > 0;
        }
    }
}

