/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.project;

import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.building.AbstractModelBuildingListener;
import hidden.org.apache.maven.model.building.ModelBuildingEvent;
import hidden.org.apache.maven.model.building.ModelProblem;
import hidden.org.apache.maven.model.building.ModelProblemCollectorRequest;
import hidden.org.apache.maven.plugin.PluginManagerException;
import hidden.org.apache.maven.plugin.PluginResolutionException;
import hidden.org.apache.maven.plugin.version.PluginVersionResolutionException;
import hidden.org.apache.maven.project.MavenProject;
import hidden.org.apache.maven.project.ProjectBuildingHelper;
import hidden.org.apache.maven.project.ProjectBuildingRequest;
import hidden.org.apache.maven.project.ProjectRealmCache;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class DefaultModelBuildingListener
extends AbstractModelBuildingListener {
    private MavenProject project;
    private ProjectBuildingHelper projectBuildingHelper;
    private ProjectBuildingRequest projectBuildingRequest;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginRepositories;

    public DefaultModelBuildingListener(MavenProject project, ProjectBuildingHelper projectBuildingHelper, ProjectBuildingRequest projectBuildingRequest) {
        this.project = Validate.notNull(project, "project cannot be null", new Object[0]);
        this.projectBuildingHelper = Validate.notNull(projectBuildingHelper, "projectBuildingHelper cannot be null", new Object[0]);
        this.projectBuildingRequest = Validate.notNull(projectBuildingRequest, "projectBuildingRequest cannot be null", new Object[0]);
        this.remoteRepositories = projectBuildingRequest.getRemoteRepositories();
        this.pluginRepositories = projectBuildingRequest.getPluginArtifactRepositories();
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void buildExtensionsAssembled(ModelBuildingEvent event) {
        Model model = event.getModel();
        try {
            this.pluginRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getPluginRepositories(), this.pluginRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.getProblems().add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Invalid plugin repository: " + e.getMessage()).setException(e));
        }
        this.project.setPluginArtifactRepositories(this.pluginRepositories);
        if (event.getRequest().isProcessPlugins()) {
            try {
                ProjectRealmCache.CacheRecord record = this.projectBuildingHelper.createProjectRealm(this.project, model, this.projectBuildingRequest);
                this.project.setClassRealm(record.getRealm());
                this.project.setExtensionDependencyFilter(record.getExtensionArtifactFilter());
            }
            catch (PluginManagerException | PluginResolutionException | PluginVersionResolutionException e) {
                event.getProblems().add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Unresolveable build extension: " + e.getMessage()).setException(e));
            }
            this.projectBuildingHelper.selectProjectRealm(this.project);
        }
        try {
            this.remoteRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getRepositories(), this.remoteRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.getProblems().add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Invalid artifact repository: " + e.getMessage()).setException(e));
        }
        this.project.setRemoteArtifactRepositories(this.remoteRepositories);
    }
}

