/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.cli.configuration;

import hidden.org.apache.maven.artifact.InvalidRepositoryException;
import hidden.org.apache.maven.bridge.MavenRepositorySystem;
import hidden.org.apache.maven.building.Source;
import hidden.org.apache.maven.cli.CliRequest;
import hidden.org.apache.maven.cli.configuration.ConfigurationProcessor;
import hidden.org.apache.maven.execution.MavenExecutionRequest;
import hidden.org.apache.maven.execution.MavenExecutionRequestPopulationException;
import hidden.org.apache.maven.settings.Mirror;
import hidden.org.apache.maven.settings.Profile;
import hidden.org.apache.maven.settings.Proxy;
import hidden.org.apache.maven.settings.Repository;
import hidden.org.apache.maven.settings.Server;
import hidden.org.apache.maven.settings.Settings;
import hidden.org.apache.maven.settings.SettingsUtils;
import hidden.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import hidden.org.apache.maven.settings.building.SettingsBuilder;
import hidden.org.apache.maven.settings.building.SettingsBuildingResult;
import hidden.org.apache.maven.settings.building.SettingsProblem;
import hidden.org.apache.maven.settings.crypto.SettingsDecrypter;
import hidden.org.slf4j.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ConfigurationProcessor.class, hint="settings")
public class SettingsXmlConfigurationProcessor
implements ConfigurationProcessor {
    public static final String HINT = "settings";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.conf"), "settings.xml");
    @Requirement
    private Logger logger;
    @Requirement
    private SettingsBuilder settingsBuilder;
    @Requirement
    private SettingsDecrypter settingsDecrypter;

    @Override
    public void process(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        CommandLine commandLine = cliRequest.getCommandLine();
        String workingDirectory = cliRequest.getWorkingDirectory();
        MavenExecutionRequest request = cliRequest.getRequest();
        if (commandLine.hasOption('s')) {
            userSettingsFile = new File(commandLine.getOptionValue('s'));
            if (!(userSettingsFile = SettingsXmlConfigurationProcessor.resolveFile(userSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        if (commandLine.hasOption("gs")) {
            globalSettingsFile = new File(commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = SettingsXmlConfigurationProcessor.resolveFile(globalSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        request.setGlobalSettingsFile(globalSettingsFile);
        request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.getSystemProperties());
        settingsRequest.setUserProperties(cliRequest.getUserProperties());
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent(settingsRequest);
        }
        this.logger.debug("Reading global settings from " + this.getLocation(settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsFile()));
        this.logger.debug("Reading user settings from " + this.getLocation(settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsFile()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build(settingsRequest);
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent(settingsResult);
        }
        this.populateFromSettings(request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.logger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.logger.warn("");
        }
    }

    private MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenExecutionRequestPopulationException {
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            server = server.clone();
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            proxy = proxy.clone();
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            mirror = mirror.clone();
            request.addMirror(mirror);
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile(rawProfile));
            if (!settings.getActiveProfiles().contains(rawProfile.getId())) continue;
            List<Repository> remoteRepositories = rawProfile.getRepositories();
            for (Repository remoteRepository : remoteRepositories) {
                try {
                    request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository(remoteRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
            List<Repository> pluginRepositories = rawProfile.getPluginRepositories();
            for (Repository pluginRepository : pluginRepositories) {
                try {
                    request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository(pluginRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
        }
        return request;
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }
}

