/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.resolver.filter;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class IncludesArtifactFilter
implements ArtifactFilter {
    private final Set<String> patterns;

    public IncludesArtifactFilter(List<String> patterns) {
        this.patterns = new LinkedHashSet<String>(patterns);
    }

    @Override
    public boolean include(Artifact artifact) {
        String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
        boolean matched = false;
        Iterator<String> i = this.patterns.iterator();
        while (i.hasNext() & !matched) {
            if (!id.equals(i.next())) continue;
            matched = true;
        }
        return matched;
    }

    public List<String> getPatterns() {
        return new ArrayList<String>(this.patterns);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.patterns.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IncludesArtifactFilter other = (IncludesArtifactFilter)obj;
        return this.patterns.equals(other.patterns);
    }
}

