/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.resolver;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.factory.ArtifactFactory;
import hidden.org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import hidden.org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import hidden.org.apache.maven.artifact.metadata.ResolutionGroup;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import hidden.org.apache.maven.artifact.repository.RepositoryRequest;
import hidden.org.apache.maven.artifact.repository.metadata.Snapshot;
import hidden.org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import hidden.org.apache.maven.artifact.resolver.ArtifactCollector;
import hidden.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolver;
import hidden.org.apache.maven.artifact.resolver.DebugResolutionListener;
import hidden.org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import hidden.org.apache.maven.artifact.resolver.ResolutionListener;
import hidden.org.apache.maven.artifact.resolver.ResolutionNode;
import hidden.org.apache.maven.artifact.resolver.WarningResolutionListener;
import hidden.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import hidden.org.apache.maven.execution.MavenSession;
import hidden.org.apache.maven.plugin.LegacySupport;
import hidden.org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import hidden.org.apache.maven.repository.legacy.resolver.conflict.ConflictResolver;
import hidden.org.apache.maven.wagon.events.TransferListener;
import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.repository.LocalRepositoryManager;
import hidden.org.eclipse.aether.resolution.ArtifactRequest;
import hidden.org.eclipse.aether.resolution.ArtifactResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;

@Component(role=ArtifactResolver.class)
public class DefaultArtifactResolver
implements ArtifactResolver,
Disposable {
    @Requirement
    private Logger logger;
    @Requirement
    protected ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactCollector artifactCollector;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private ArtifactMetadataSource source;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private RepositorySystem repoSystem;
    private final Executor executor;

    public DefaultArtifactResolver() {
        int threads = Integer.getInteger("maven.artifact.threads", 5);
        this.executor = threads <= 1 ? new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        } : new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadCreator());
    }

    private RepositorySystemSession getSession(ArtifactRepository localRepository) {
        return LegacyLocalRepositoryManager.overlay(localRepository, this.legacySupport.getRepositorySession(), this.repoSystem);
    }

    private void injectSession1(RepositoryRequest request, MavenSession session) {
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setForceUpdate(session.getRequest().isUpdateSnapshots());
        }
    }

    private void injectSession2(ArtifactResolutionRequest request, MavenSession session) {
        this.injectSession1(request, session);
        if (session != null) {
            request.setServers(session.getRequest().getServers());
            request.setMirrors(session.getRequest().getMirrors());
            request.setProxies(session.getRequest().getProxies());
        }
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, TransferListener resolutionListener) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, this.getSession(localRepository));
    }

    @Override
    public void resolveAlways(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, this.getSession(localRepository));
    }

    private void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, RepositorySystemSession session) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if ("system".equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.exists()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            if (!systemFile.isFile()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            artifact.setResolved(true);
            return;
        }
        if (!artifact.isResolved()) {
            Matcher matcher;
            ArtifactResult result;
            try {
                ArtifactRequest artifactRequest = new ArtifactRequest();
                artifactRequest.setArtifact(RepositoryUtils.toArtifact(artifact));
                artifactRequest.setRepositories(RepositoryUtils.toRepos(remoteRepositories));
                LocalRepositoryManager lrm = session.getLocalRepositoryManager();
                String path = lrm.getPathForLocalArtifact(artifactRequest.getArtifact());
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
                result = this.repoSystem.resolveArtifact(session, artifactRequest);
            }
            catch (hidden.org.eclipse.aether.resolution.ArtifactResolutionException e) {
                if (e.getCause() instanceof hidden.org.eclipse.aether.transfer.ArtifactNotFoundException) {
                    throw new ArtifactNotFoundException(e.getMessage(), artifact, remoteRepositories, e);
                }
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
            }
            artifact.selectVersion(result.getArtifact().getVersion());
            artifact.setFile(result.getArtifact().getFile());
            artifact.setResolved(true);
            if (artifact.isSnapshot() && (matcher = Artifact.VERSION_FILE_PATTERN.matcher(artifact.getVersion())).matches()) {
                Snapshot snapshot = new Snapshot();
                snapshot.setTimestamp(matcher.group(2));
                try {
                    snapshot.setBuildNumber(Integer.parseInt(matcher.group(3)));
                    artifact.addMetadata(new SnapshotArtifactRepositoryMetadata(artifact, snapshot));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Invalid artifact version " + artifact.getVersion() + ": " + e.getMessage());
                }
            }
        }
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.emptyMap(), localRepository, remoteRepositories, source, filter);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map<String, Artifact> managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map<String, Artifact> managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.emptyMap(), localRepository, remoteRepositories, source, null, listeners);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map<String, Artifact> managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map<String, Artifact> managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionRequest request = ((ArtifactResolutionRequest)new ArtifactResolutionRequest().setArtifact(originatingArtifact).setResolveRoot(false).setArtifactDependencies(artifacts).setManagedVersionMap(managedVersions).setLocalRepository(localRepository).setRemoteRepositories((List)remoteRepositories)).setCollectionFilter(filter).setListeners(listeners);
        this.injectSession2(request, this.legacySupport.getSession());
        return this.resolveWithExceptions(request);
    }

    public ArtifactResolutionResult resolveWithExceptions(ArtifactResolutionRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult result = this.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, result);
        return result;
    }

    @Override
    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        Artifact rootArtifact = request.getArtifact();
        Set<Artifact> artifacts = request.getArtifactDependencies();
        Map<String, Artifact> managedVersions = request.getManagedVersionMap();
        List<ResolutionListener> listeners = request.getListeners();
        ArtifactFilter collectionFilter = request.getCollectionFilter();
        ArtifactFilter resolutionFilter = request.getResolutionFilter();
        RepositorySystemSession session = this.getSession(request.getLocalRepository());
        if (this.source == null) {
            try {
                this.source = this.container.lookup(ArtifactMetadataSource.class);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        if (listeners == null) {
            listeners = new ArrayList<ResolutionListener>();
            if (this.logger.isDebugEnabled()) {
                listeners.add(new DebugResolutionListener(this.logger));
            }
            listeners.add(new WarningResolutionListener(this.logger));
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        if (request.isResolveRoot()) {
            try {
                this.resolve(rootArtifact, request.getRemoteRepositories(), session);
            }
            catch (ArtifactResolutionException e) {
                result.addErrorArtifactException(e);
                return result;
            }
            catch (ArtifactNotFoundException e) {
                result.addMissingArtifact(request.getArtifact());
                return result;
            }
        }
        ArtifactResolutionRequest collectionRequest = request;
        if (request.isResolveTransitively()) {
            DefaultMetadataResolutionRequest metadataRequest = new DefaultMetadataResolutionRequest(request);
            metadataRequest.setArtifact(rootArtifact);
            metadataRequest.setResolveManagedVersions(managedVersions == null);
            try {
                ResolutionGroup resolutionGroup = this.source.retrieve(metadataRequest);
                if (managedVersions == null) {
                    managedVersions = resolutionGroup.getManagedVersions();
                }
                Set<Artifact> directArtifacts = resolutionGroup.getArtifacts();
                if (artifacts == null || artifacts.isEmpty()) {
                    artifacts = directArtifacts;
                } else {
                    ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
                    allArtifacts.addAll(artifacts);
                    allArtifacts.addAll(directArtifacts);
                    LinkedHashMap<String, Artifact> mergedArtifacts = new LinkedHashMap<String, Artifact>();
                    for (Artifact artifact : allArtifacts) {
                        String conflictId = artifact.getDependencyConflictId();
                        if (mergedArtifacts.containsKey(conflictId)) continue;
                        mergedArtifacts.put(conflictId, artifact);
                    }
                    artifacts = new LinkedHashSet(mergedArtifacts.values());
                }
                collectionRequest = new ArtifactResolutionRequest(request);
                collectionRequest.setServers(request.getServers());
                collectionRequest.setMirrors(request.getMirrors());
                collectionRequest.setProxies(request.getProxies());
                collectionRequest.setRemoteRepositories((List)resolutionGroup.getResolutionRepositories());
            }
            catch (ArtifactMetadataRetrievalException e) {
                ArtifactResolutionException are = new ArtifactResolutionException("Unable to get dependency information for " + rootArtifact.getId() + ": " + e.getMessage(), rootArtifact, metadataRequest.getRemoteRepositories(), e);
                result.addMetadataResolutionException(are);
                return result;
            }
        }
        if (artifacts == null || artifacts.isEmpty()) {
            if (request.isResolveRoot()) {
                result.addArtifact(rootArtifact);
            }
            return result;
        }
        result = this.artifactCollector.collect(artifacts, rootArtifact, managedVersions, collectionRequest, this.source, collectionFilter, listeners, null);
        if (result.hasMetadataResolutionExceptions() || result.hasVersionRangeViolations() || result.hasCircularDependencyExceptions()) {
            this.logger.info("Failure detected.");
            return result;
        }
        if (result.getArtifactResolutionNodes() != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            CountDownLatch latch = new CountDownLatch(result.getArtifactResolutionNodes().size());
            for (ResolutionNode node : result.getArtifactResolutionNodes()) {
                Artifact artifact = node.getArtifact();
                if (resolutionFilter == null || resolutionFilter.include(artifact)) {
                    this.executor.execute(new ResolveTask(classLoader, latch, artifact, session, node.getRemoteRepositories(), result));
                    continue;
                }
                latch.countDown();
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                result.addErrorArtifactException(new ArtifactResolutionException("Resolution interrupted", rootArtifact, e));
            }
        }
        if (request.isResolveRoot()) {
            LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>();
            allArtifacts.add(rootArtifact);
            allArtifacts.addAll(result.getArtifacts());
            result.setArtifacts(allArtifacts);
        }
        return result;
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, null);
    }

    @Override
    public void dispose() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
    }

    private class ResolveTask
    implements Runnable {
        private final ClassLoader classLoader;
        private final CountDownLatch latch;
        private final Artifact artifact;
        private final RepositorySystemSession session;
        private final List<ArtifactRepository> remoteRepositories;
        private final ArtifactResolutionResult result;

        ResolveTask(ClassLoader classLoader, CountDownLatch latch, Artifact artifact, RepositorySystemSession session, List<ArtifactRepository> remoteRepositories, ArtifactResolutionResult result) {
            this.classLoader = classLoader;
            this.latch = latch;
            this.artifact = artifact;
            this.session = session;
            this.remoteRepositories = remoteRepositories;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                DefaultArtifactResolver.this.resolve(this.artifact, (List<ArtifactRepository>)this.remoteRepositories, this.session);
            }
            catch (ArtifactNotFoundException anfe) {
                ArtifactResolutionResult artifactResolutionResult = this.result;
                synchronized (artifactResolutionResult) {
                    this.result.addMissingArtifact(this.artifact);
                }
            }
            catch (ArtifactResolutionException e) {
                ArtifactResolutionResult artifactResolutionResult = this.result;
                synchronized (artifactResolutionResult) {
                    this.result.addErrorArtifactException(e);
                }
            }
            finally {
                this.latch.countDown();
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    static final class DaemonThreadCreator
    implements ThreadFactory {
        static final String THREADGROUP_NAME = "hidden.org.apache.maven.artifact.resolver.DefaultArtifactResolver";
        static final ThreadGroup GROUP = new ThreadGroup("hidden.org.apache.maven.artifact.resolver.DefaultArtifactResolver");
        static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);

        DaemonThreadCreator() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread newThread = new Thread(GROUP, r, "resolver-" + THREAD_NUMBER.getAndIncrement());
            newThread.setDaemon(true);
            newThread.setContextClassLoader(null);
            return newThread;
        }
    }
}

