/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.collect.ImmutableList;
import hidden.com.google.common.collect.Lists;
import hidden.com.google.inject.ConfigurationException;
import hidden.com.google.inject.Stage;
import hidden.com.google.inject.internal.AbstractProcessor;
import hidden.com.google.inject.internal.Errors;
import hidden.com.google.inject.internal.Initializer;
import hidden.com.google.inject.internal.InjectorImpl;
import hidden.com.google.inject.internal.InternalContext;
import hidden.com.google.inject.internal.InternalProvisionException;
import hidden.com.google.inject.internal.SingleMemberInjector;
import hidden.com.google.inject.spi.InjectionRequest;
import hidden.com.google.inject.spi.StaticInjectionRequest;
import java.util.List;
import java.util.Set;

final class InjectionRequestProcessor
extends AbstractProcessor {
    private final List<StaticInjection> staticInjections = Lists.newArrayList();
    private final Initializer initializer;

    InjectionRequestProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public Boolean visit(StaticInjectionRequest request) {
        this.staticInjections.add(new StaticInjection(this.injector, request));
        return true;
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        Set injectionPoints;
        try {
            injectionPoints = request.getInjectionPoints();
        }
        catch (ConfigurationException e) {
            this.errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        this.initializer.requestInjection(this.injector, request.getInstance(), null, request.getSource(), injectionPoints);
        return true;
    }

    void validate() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.validate();
        }
    }

    void injectMembers() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.injectMembers();
        }
    }

    private class StaticInjection {
        final InjectorImpl injector;
        final Object source;
        final StaticInjectionRequest request;
        ImmutableList<SingleMemberInjector> memberInjectors;

        public StaticInjection(InjectorImpl injector, StaticInjectionRequest request) {
            this.injector = injector;
            this.source = request.getSource();
            this.request = request;
        }

        void validate() {
            Set injectionPoints;
            Errors errorsForMember = InjectionRequestProcessor.this.errors.withSource(this.source);
            try {
                injectionPoints = this.request.getInjectionPoints();
            }
            catch (ConfigurationException e) {
                errorsForMember.merge(e.getErrorMessages());
                injectionPoints = (Set)e.getPartialValue();
            }
            this.memberInjectors = injectionPoints != null ? this.injector.membersInjectorStore.getInjectors(injectionPoints, errorsForMember) : ImmutableList.of();
            InjectionRequestProcessor.this.errors.merge(errorsForMember);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void injectMembers() {
            try (InternalContext context = this.injector.enterContext();){
                boolean isStageTool = this.injector.options.stage == Stage.TOOL;
                for (SingleMemberInjector memberInjector : this.memberInjectors) {
                    if (isStageTool && !memberInjector.getInjectionPoint().isToolable()) continue;
                    try {
                        memberInjector.inject(context, null);
                    }
                    catch (InternalProvisionException e) {
                        InjectionRequestProcessor.this.errors.merge(e);
                    }
                }
            }
        }
    }
}

