/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class SimpleResourceHolder {
    private static final String FOR_KEY = "] for key [";
    private static final String BOUND_TO_THREAD = "] bound to thread [";
    private static final Log logger = LogFactory.getLog(SimpleResourceHolder.class);
    private static final ThreadLocal<Map<Object, Object>> resources = new NamedThreadLocal("Simple resources");

    public static Map<Object, Object> getResources() {
        Map<Object, Object> map = resources.get();
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static boolean has(Object key) {
        Object value = SimpleResourceHolder.doGet(key);
        return value != null;
    }

    @Nullable
    public static Object get(Object key) {
        Object value = SimpleResourceHolder.doGet(key);
        if (value != null && logger.isTraceEnabled()) {
            logger.trace((Object)("Retrieved value [" + value + FOR_KEY + key + BOUND_TO_THREAD + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    @Nullable
    private static Object doGet(Object actualKey) {
        Map<Object, Object> map = resources.get();
        if (map == null) {
            return null;
        }
        return map.get(actualKey);
    }

    public static void bind(Object key, Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Map<Object, Object> map = resources.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            resources.set(map);
        }
        Object oldValue = map.put(key, value);
        Assert.isNull((Object)oldValue, () -> "Already value [" + oldValue + FOR_KEY + key + BOUND_TO_THREAD + Thread.currentThread().getName() + "]");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Bound value [" + value + FOR_KEY + key + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static Object unbind(Object key) throws IllegalStateException {
        Object value = SimpleResourceHolder.unbindIfPossible(key);
        Assert.notNull((Object)value, () -> "No value for key [" + key + BOUND_TO_THREAD + Thread.currentThread().getName() + "]");
        return value;
    }

    @Nullable
    public static Object unbindIfPossible(Object key) {
        Map<Object, Object> map = resources.get();
        if (map == null) {
            return null;
        }
        Object value = map.remove(key);
        if (map.isEmpty()) {
            resources.remove();
        }
        if (value != null && logger.isTraceEnabled()) {
            logger.trace((Object)("Removed value [" + value + FOR_KEY + key + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static void clear() {
        resources.remove();
    }

    private SimpleResourceHolder() {
    }
}

