/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmCallback;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnCallback;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ClosingRecoveryListener;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.connection.PendingConfirm;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PublisherCallbackChannelImpl
implements PublisherCallbackChannel,
ConfirmListener,
ReturnListener,
ShutdownListener {
    private static final MessagePropertiesConverter converter = new DefaultMessagePropertiesConverter();
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Channel delegate;
    private final ConcurrentMap<String, PublisherCallbackChannel.Listener> listeners = new ConcurrentHashMap<String, PublisherCallbackChannel.Listener>();
    private final Map<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> pendingConfirms = new ConcurrentHashMap<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>>();
    private final Map<String, PendingConfirm> pendingReturns = new ConcurrentHashMap<String, PendingConfirm>();
    private final SortedMap<Long, PublisherCallbackChannel.Listener> listenerForSeq = new ConcurrentSkipListMap<Long, PublisherCallbackChannel.Listener>();
    private final ExecutorService executor;
    private volatile Consumer<Channel> afterAckCallback;

    @Deprecated
    public PublisherCallbackChannelImpl(Channel delegate) {
        this(delegate, null);
    }

    public PublisherCallbackChannelImpl(Channel delegate, ExecutorService executor) {
        Assert.notNull((Object)executor, (String)"'executor' must not be null");
        this.delegate = delegate;
        this.executor = executor;
        delegate.addShutdownListener((ShutdownListener)this);
    }

    @Override
    public synchronized void setAfterAckCallback(Consumer<Channel> callback) {
        if (this.getPendingConfirmsCount() == 0 && callback != null) {
            callback.accept(this);
        } else {
            this.afterAckCallback = callback;
        }
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.delegate.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.delegate.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public int getChannelNumber() {
        return this.delegate.getChannelNumber();
    }

    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    public void close(int closeCode, String closeMessage) throws IOException, TimeoutException {
        this.delegate.close(closeCode, closeMessage);
        if (this.delegate instanceof AutorecoveringChannel) {
            ClosingRecoveryListener.removeChannel((AutorecoveringChannel)this.delegate);
        }
    }

    public void abort() throws IOException {
        this.delegate.abort();
    }

    public void abort(int closeCode, String closeMessage) throws IOException {
        this.delegate.abort(closeCode, closeMessage);
    }

    public com.rabbitmq.client.Consumer getDefaultConsumer() {
        return this.delegate.getDefaultConsumer();
    }

    public void setDefaultConsumer(com.rabbitmq.client.Consumer consumer) {
        this.delegate.setDefaultConsumer(consumer);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        this.delegate.basicQos(prefetchSize, prefetchCount, global);
    }

    public void basicQos(int prefetchCount, boolean global) throws IOException {
        this.delegate.basicQos(prefetchCount, global);
    }

    public void basicQos(int prefetchCount) throws IOException {
        this.delegate.basicQos(prefetchCount);
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
        return this.delegate.exchangeDeclarePassive(name);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        return this.delegate.exchangeDelete(exchange, ifUnused);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.delegate.exchangeDelete(exchange);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
        return this.delegate.exchangeBind(destination, source, routingKey);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeBind(destination, source, routingKey, arguments);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
        return this.delegate.exchangeUnbind(destination, source, routingKey);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeUnbind(destination, source, routingKey, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.delegate.queueDeclare();
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return this.delegate.queueDeclarePassive(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.delegate.queueDelete(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return this.delegate.queueDelete(queue, ifUnused, ifEmpty);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.delegate.queueBind(queue, exchange, routingKey);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueBind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.delegate.queueUnbind(queue, exchange, routingKey);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueUnbind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return this.delegate.queuePurge(queue);
    }

    public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
        return this.delegate.basicGet(queue, autoAck);
    }

    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.delegate.basicAck(deliveryTag, multiple);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        this.delegate.basicNack(deliveryTag, multiple, requeue);
    }

    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        this.delegate.basicReject(deliveryTag, requeue);
    }

    public String basicConsume(String queue, com.rabbitmq.client.Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, callback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.delegate.basicConsume(queue, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, com.rabbitmq.client.Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, callback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, com.rabbitmq.client.Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, com.rabbitmq.client.Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, arguments, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, arguments, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, com.rabbitmq.client.Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public void basicCancel(String consumerTag) throws IOException {
        this.delegate.basicCancel(consumerTag);
    }

    public AMQP.Basic.RecoverOk basicRecover() throws IOException {
        return this.delegate.basicRecover();
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return this.delegate.basicRecover(requeue);
    }

    public AMQP.Tx.SelectOk txSelect() throws IOException {
        return this.delegate.txSelect();
    }

    public AMQP.Tx.CommitOk txCommit() throws IOException {
        return this.delegate.txCommit();
    }

    public AMQP.Tx.RollbackOk txRollback() throws IOException {
        return this.delegate.txRollback();
    }

    public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
        return this.delegate.confirmSelect();
    }

    public long getNextPublishSeqNo() {
        return this.delegate.getNextPublishSeqNo();
    }

    public boolean waitForConfirms() throws InterruptedException {
        return this.delegate.waitForConfirms();
    }

    public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
        return this.delegate.waitForConfirms(timeout);
    }

    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        this.delegate.waitForConfirmsOrDie();
    }

    public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
        this.delegate.waitForConfirmsOrDie(timeout);
    }

    public void asyncRpc(Method method) throws IOException {
        this.delegate.asyncRpc(method);
    }

    public Command rpc(Method method) throws IOException {
        return this.delegate.rpc(method);
    }

    public void addConfirmListener(ConfirmListener listener) {
        this.delegate.addConfirmListener(listener);
    }

    public ConfirmListener addConfirmListener(ConfirmCallback ackCallback, ConfirmCallback nackCallback) {
        return this.delegate.addConfirmListener(ackCallback, nackCallback);
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        return this.delegate.removeConfirmListener(listener);
    }

    public void clearConfirmListeners() {
        this.delegate.clearConfirmListeners();
    }

    public void addReturnListener(ReturnListener listener) {
        this.delegate.addReturnListener(listener);
    }

    public ReturnListener addReturnListener(ReturnCallback returnCallback) {
        return this.delegate.addReturnListener(returnCallback);
    }

    public boolean removeReturnListener(ReturnListener listener) {
        return this.delegate.removeReturnListener(listener);
    }

    public synchronized void clearReturnListeners() {
        this.delegate.clearReturnListeners();
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeBind(destination, source, routingKey, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) throws IOException {
        this.delegate.exchangeDeleteNoWait(exchange, ifUnused);
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeUnbindNoWait(destination, source, routingKey, arguments);
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.queueBindNoWait(queue, exchange, routingKey, arguments);
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        this.delegate.queueDeclareNoWait(queue, durable, exclusive, autoDelete, arguments);
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        this.delegate.queueDeleteNoWait(queue, ifUnused, ifEmpty);
    }

    public long consumerCount(String queue) throws IOException {
        return this.delegate.consumerCount(queue);
    }

    public CompletableFuture<Command> asyncCompletableRpc(Method method) throws IOException {
        return this.delegate.asyncCompletableRpc(method);
    }

    public long messageCount(String queue) throws IOException {
        return this.delegate.messageCount(queue);
    }

    @Override
    public Channel getDelegate() {
        return this.delegate;
    }

    public void close() throws IOException, TimeoutException {
        block3: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing " + this.delegate));
            }
            try {
                this.delegate.close();
            }
            catch (AlreadyClosedException e) {
                if (!this.logger.isTraceEnabled()) break block3;
                this.logger.trace((Object)(this.delegate + " is already closed"));
            }
        }
        this.shutdownCompleted("Channel closed by application");
    }

    private void shutdownCompleted(String cause) {
        this.executor.execute(() -> this.generateNacksForPendingAcks(cause));
    }

    private synchronized void generateNacksForPendingAcks(String cause) {
        for (Map.Entry<PublisherCallbackChannel.Listener, SortedMap<Long, PendingConfirm>> entry : this.pendingConfirms.entrySet()) {
            PublisherCallbackChannel.Listener listener = entry.getKey();
            for (Map.Entry<Long, PendingConfirm> confirmEntry : entry.getValue().entrySet()) {
                confirmEntry.getValue().setCause(cause);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this.toString() + " PC:Nack:(close):" + confirmEntry.getKey()));
                }
                this.processAck(confirmEntry.getKey(), false, false, false);
            }
            listener.revoke(this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"PendingConfirms cleared");
        }
        this.pendingConfirms.clear();
        this.listenerForSeq.clear();
        this.listeners.clear();
    }

    @Override
    public synchronized int getPendingConfirmsCount(PublisherCallbackChannel.Listener listener) {
        SortedMap<Long, PendingConfirm> pendingConfirmsForListener = this.pendingConfirms.get(listener);
        if (pendingConfirmsForListener == null) {
            return 0;
        }
        return pendingConfirmsForListener.entrySet().size();
    }

    @Override
    public synchronized int getPendingConfirmsCount() {
        return this.pendingConfirms.values().stream().mapToInt(Map::size).sum();
    }

    @Override
    public void addListener(PublisherCallbackChannel.Listener listener) {
        Assert.notNull((Object)listener, (String)"Listener cannot be null");
        if (this.listeners.size() == 0) {
            this.delegate.addConfirmListener((ConfirmListener)this);
            this.delegate.addReturnListener((ReturnListener)this);
        }
        if (this.listeners.putIfAbsent(listener.getUUID(), listener) == null) {
            this.pendingConfirms.put(listener, new ConcurrentSkipListMap());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added listener " + listener));
            }
        }
    }

    @Override
    public synchronized Collection<PendingConfirm> expire(PublisherCallbackChannel.Listener listener, long cutoffTime) {
        PendingConfirm pendingConfirm;
        SortedMap<Long, PendingConfirm> pendingConfirmsForListener = this.pendingConfirms.get(listener);
        if (pendingConfirmsForListener == null) {
            return Collections.emptyList();
        }
        ArrayList<PendingConfirm> expired = new ArrayList<PendingConfirm>();
        Iterator<Map.Entry<Long, PendingConfirm>> iterator = pendingConfirmsForListener.entrySet().iterator();
        while (iterator.hasNext() && (pendingConfirm = iterator.next().getValue()).getTimestamp() < cutoffTime) {
            expired.add(pendingConfirm);
            iterator.remove();
            CorrelationData correlationData = pendingConfirm.getCorrelationData();
            if (correlationData == null || !StringUtils.hasText((String)correlationData.getId())) continue;
            this.pendingReturns.remove(correlationData.getId());
        }
        return expired;
    }

    public void handleAck(long seq, boolean multiple) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.toString() + " PC:Ack:" + seq + ":" + multiple));
        }
        this.processAck(seq, true, multiple, true);
    }

    public void handleNack(long seq, boolean multiple) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.toString() + " PC:Nack:" + seq + ":" + multiple));
        }
        this.processAck(seq, false, multiple, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processAck(long seq, boolean ack, boolean multiple, boolean remove) {
        try {
            this.doProcessAck(seq, ack, multiple, remove);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to process publisher confirm", (Throwable)e);
        }
        finally {
            try {
                if (this.afterAckCallback != null && this.getPendingConfirmsCount() == 0) {
                    this.afterAckCallback.accept(this);
                    this.afterAckCallback = null;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to invoke afterAckCallback", (Throwable)e);
            }
        }
    }

    private void doProcessAck(long seq, boolean ack, boolean multiple, boolean remove) {
        if (multiple) {
            this.processMultipleAck(seq, ack);
        } else {
            PublisherCallbackChannel.Listener listener = (PublisherCallbackChannel.Listener)this.listenerForSeq.remove(seq);
            if (listener != null) {
                SortedMap<Long, PendingConfirm> confirmsForListener = this.pendingConfirms.get(listener);
                PendingConfirm pendingConfirm = null;
                if (confirmsForListener != null) {
                    pendingConfirm = remove ? (PendingConfirm)confirmsForListener.remove(seq) : (PendingConfirm)confirmsForListener.get(seq);
                }
                if (pendingConfirm != null) {
                    CorrelationData correlationData = pendingConfirm.getCorrelationData();
                    if (correlationData != null) {
                        correlationData.getFuture().set((Object)new CorrelationData.Confirm(ack, pendingConfirm.getCause()));
                        if (StringUtils.hasText((String)correlationData.getId())) {
                            this.pendingReturns.remove(correlationData.getId());
                        }
                    }
                    this.doHandleConfirm(ack, listener, pendingConfirm);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.delegate.toString() + " No listener for seq:" + seq));
            }
        }
    }

    private void processMultipleAck(long seq, boolean ack) {
        SortedMap<Long, PublisherCallbackChannel.Listener> involvedListeners = this.listenerForSeq.headMap(seq + 1L);
        HashSet listenersForAcks = new HashSet(involvedListeners.values());
        for (PublisherCallbackChannel.Listener involvedListener : listenersForAcks) {
            SortedMap<Long, PendingConfirm> confirmsMap = this.pendingConfirms.get(involvedListener);
            if (confirmsMap == null) continue;
            SortedMap<Long, PendingConfirm> confirms = confirmsMap.headMap(seq + 1L);
            Iterator iterator = confirms.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PendingConfirm value = (PendingConfirm)entry.getValue();
                CorrelationData correlationData = value.getCorrelationData();
                if (correlationData != null) {
                    correlationData.getFuture().set((Object)new CorrelationData.Confirm(ack, value.getCause()));
                    if (StringUtils.hasText((String)correlationData.getId())) {
                        this.pendingReturns.remove(correlationData.getId());
                    }
                }
                iterator.remove();
                this.doHandleConfirm(ack, involvedListener, value);
            }
        }
        ArrayList seqs = new ArrayList(involvedListeners.keySet());
        for (Long key : seqs) {
            this.listenerForSeq.remove(key);
        }
    }

    private void doHandleConfirm(boolean ack, PublisherCallbackChannel.Listener listener, PendingConfirm pendingConfirm) {
        try {
            if (listener.isConfirmListener()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending confirm " + pendingConfirm));
                }
                listener.handleConfirm(pendingConfirm, ack);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception delivering confirm", (Throwable)e);
        }
    }

    @Override
    public synchronized void addPendingConfirm(PublisherCallbackChannel.Listener listener, long seq, PendingConfirm pendingConfirm) {
        String returnCorrelation;
        SortedMap<Long, PendingConfirm> pendingConfirmsForListener = this.pendingConfirms.get(listener);
        Assert.notNull(pendingConfirmsForListener, (String)("Listener not registered: " + listener + " " + this.pendingConfirms.keySet()));
        pendingConfirmsForListener.put(seq, pendingConfirm);
        this.listenerForSeq.put(seq, listener);
        if (pendingConfirm.getCorrelationData() != null && StringUtils.hasText((String)(returnCorrelation = pendingConfirm.getCorrelationData().getId()))) {
            this.pendingReturns.put(returnCorrelation, pendingConfirm);
        }
    }

    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        PendingConfirm confirm;
        LongString returnCorrelation = (LongString)properties.getHeaders().get("spring_returned_message_correlation");
        if (returnCorrelation != null && (confirm = this.pendingReturns.remove(returnCorrelation.toString())) != null) {
            MessageProperties messageProperties = converter.toMessageProperties(properties, new Envelope(0L, false, exchange, routingKey), StandardCharsets.UTF_8.name());
            if (confirm.getCorrelationData() != null) {
                confirm.getCorrelationData().setReturnedMessage(new Message(body, messageProperties));
            }
        }
        Object returnListenerHeader = properties.getHeaders().get("spring_listener_return_correlation");
        String uuidObject = null;
        if (returnListenerHeader != null) {
            uuidObject = returnListenerHeader.toString();
        }
        PublisherCallbackChannel.Listener listener = null;
        if (uuidObject != null) {
            listener = (PublisherCallbackChannel.Listener)this.listeners.get(uuidObject);
        } else {
            this.logger.error((Object)"No 'spring_listener_return_correlation' header in returned message");
        }
        if (listener == null || !listener.isReturnListener()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"No Listener for returned message");
            }
        } else {
            try {
                listener.handleReturn(replyCode, replyText, exchange, routingKey, properties, body);
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception delivering returned message ", (Throwable)e);
            }
        }
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        this.shutdownCompleted(cause.getMessage());
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || this.delegate.equals(obj);
    }

    public String toString() {
        return "PublisherCallbackChannelImpl: " + this.delegate.toString();
    }
}

