/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.ReplyFailureException;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class AbstractAdaptableMessageListener
implements MessageListener,
ChannelAwareMessageListener {
    private static final String DEFAULT_RESPONSE_ROUTING_KEY = "";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext("!{", "}");
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final StandardEvaluationContext evalContext = new StandardEvaluationContext();
    private String responseRoutingKey = "";
    private String responseExchange = null;
    private Address responseAddress = null;
    private Expression responseExpression;
    private volatile boolean mandatoryPublish;
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private String encoding = "UTF-8";
    private MessagePostProcessor[] beforeSendReplyPostProcessors;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<?> recoveryCallback;

    public void setResponseRoutingKey(String responseRoutingKey) {
        this.responseRoutingKey = responseRoutingKey;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setResponseExchange(String responseExchange) {
        this.responseExchange = responseExchange;
    }

    public void setResponseAddress(String defaultReplyTo) {
        if (defaultReplyTo.startsWith(PARSER_CONTEXT.getExpressionPrefix())) {
            this.responseExpression = PARSER.parseExpression(defaultReplyTo, PARSER_CONTEXT);
        } else {
            this.responseAddress = new Address(defaultReplyTo);
        }
    }

    public void setMandatoryPublish(boolean mandatoryPublish) {
        this.mandatoryPublish = mandatoryPublish;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Deprecated
    public void setReplyPostProcessor(MessagePostProcessor replyPostProcessor) {
        this.setBeforeSendReplyPostProcessors(replyPostProcessor);
    }

    public void setBeforeSendReplyPostProcessors(MessagePostProcessor ... beforeSendReplyPostProcessors) {
        Assert.noNullElements((Object[])beforeSendReplyPostProcessors, (String)"'replyPostProcessors' must not have any null elements");
        this.beforeSendReplyPostProcessors = Arrays.copyOf(beforeSendReplyPostProcessors, beforeSendReplyPostProcessors.length);
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.evalContext.setBeanResolver(beanResolver);
        this.evalContext.setTypeConverter((TypeConverter)new StandardTypeConverter());
        this.evalContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void onMessage(Message message) {
        try {
            this.onMessage(message, null);
        }
        catch (Exception e) {
            throw new ListenerExecutionFailedException("Listener threw exception", e, message);
        }
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.fromMessage(message);
        }
        return message;
    }

    protected void handleResult(Object resultArg, Message request, Channel channel) throws Exception {
        this.handleResult(resultArg, request, channel, null);
    }

    protected void handleResult(Object resultArg, Message request, Channel channel, Object source) throws Exception {
        if (channel != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Listener method returned result [" + resultArg + "] - generating response message for it"));
            }
            try {
                Object result = resultArg instanceof ResultHolder ? ((ResultHolder)resultArg).result : resultArg;
                Message response = this.buildMessage(channel, result);
                this.postProcessResponse(request, response);
                Address replyTo = this.getReplyToAddress(request, source, resultArg);
                this.sendResponse(channel, replyTo, response);
            }
            catch (Exception ex) {
                throw new ReplyFailureException("Failed to send reply with payload '" + resultArg + "'", ex);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Listener method returned result [" + resultArg + "]: not generating response message for it because no Rabbit Channel given"));
        }
    }

    protected String getReceivedExchange(Message request) {
        return request.getMessageProperties().getReceivedExchange();
    }

    protected Message buildMessage(Channel channel, Object result) throws Exception {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof Message)) {
            return converter.toMessage(result, new MessageProperties());
        }
        if (!(result instanceof Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (Message)result;
    }

    protected void postProcessResponse(Message request, Message response) throws Exception {
        String messageId;
        String correlation = request.getMessageProperties().getCorrelationId();
        if (correlation == null && (messageId = request.getMessageProperties().getMessageId()) != null) {
            correlation = messageId;
        }
        response.getMessageProperties().setCorrelationId(correlation);
    }

    protected Address getReplyToAddress(Message request, Object source, Object result) throws Exception {
        Address replyTo = request.getMessageProperties().getReplyToAddress();
        if (replyTo == null) {
            if (this.responseAddress == null && this.responseExchange != null) {
                this.responseAddress = new Address(this.responseExchange, this.responseRoutingKey);
            }
            if (result instanceof ResultHolder) {
                replyTo = this.evaluateReplyTo(request, source, result, ((ResultHolder)result).sendTo);
            } else if (this.responseExpression != null) {
                replyTo = this.evaluateReplyTo(request, source, result, this.responseExpression);
            } else {
                if (this.responseAddress == null) {
                    throw new AmqpException("Cannot determine ReplyTo message property value: Request message does not contain reply-to property, and no default response Exchange was set.");
                }
                replyTo = this.responseAddress;
            }
        }
        return replyTo;
    }

    private Address evaluateReplyTo(Message request, Object source, Object result, Expression expression) {
        Address replyTo = null;
        Object value = expression.getValue((EvaluationContext)this.evalContext, (Object)new ReplyExpressionRoot(request, source, result));
        Assert.state((value instanceof String || value instanceof Address ? 1 : 0) != 0, (String)"response expression must evaluate to a String or Address");
        replyTo = value instanceof String ? new Address((String)value) : (Address)value;
        return replyTo;
    }

    protected void sendResponse(Channel channel, Address replyTo, Message messageIn) throws Exception {
        Message message = messageIn;
        if (this.beforeSendReplyPostProcessors != null) {
            for (MessagePostProcessor postProcessor : this.beforeSendReplyPostProcessors) {
                message = postProcessor.postProcessMessage(message);
            }
        }
        this.postProcessChannel(channel, message);
        try {
            this.logger.debug((Object)("Publishing response to exchange = [" + replyTo.getExchangeName() + "], routingKey = [" + replyTo.getRoutingKey() + "]"));
            if (this.retryTemplate == null) {
                this.doPublish(channel, replyTo, message);
            } else {
                Message messageToSend = message;
                this.retryTemplate.execute(ctx -> {
                    this.doPublish(channel, replyTo, messageToSend);
                    return null;
                }, ctx -> {
                    if (this.recoveryCallback != null) {
                        ctx.setAttribute("message", (Object)messageToSend);
                        ctx.setAttribute("address", (Object)replyTo);
                        this.recoveryCallback.recover(ctx);
                        return null;
                    }
                    throw RabbitExceptionTranslator.convertRabbitAccessException(ctx.getLastThrowable());
                });
            }
        }
        catch (Exception ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
    }

    protected void doPublish(Channel channel, Address replyTo, Message message) throws IOException {
        channel.basicPublish(replyTo.getExchangeName(), replyTo.getRoutingKey(), this.mandatoryPublish, this.messagePropertiesConverter.fromMessageProperties(message.getMessageProperties(), this.encoding), message.getBody());
    }

    protected void postProcessChannel(Channel channel, Message response) throws Exception {
    }

    public static final class ReplyExpressionRoot {
        private final Message request;
        private final Object source;
        private final Object result;

        public ReplyExpressionRoot(Message request, Object source, Object result) {
            this.request = request;
            this.source = source;
            this.result = result;
        }

        public Message getRequest() {
            return this.request;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getResult() {
            return this.result;
        }
    }

    public static final class ResultHolder {
        private final Object result;
        private final Expression sendTo;

        public ResultHolder(Object result, Expression sendTo) {
            this.result = result;
            this.sendTo = sendTo;
        }

        public String toString() {
            return this.result.toString();
        }
    }
}

