/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.scheduling.TaskScheduler;

public class DirectRabbitListenerContainerFactory
extends AbstractRabbitListenerContainerFactory<DirectMessageListenerContainer> {
    private TaskScheduler taskScheduler;
    private Long monitorInterval;
    private Integer consumersPerQueue = 1;

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setMonitorInterval(long monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void setConsumersPerQueue(Integer consumersPerQueue) {
        this.consumersPerQueue = consumersPerQueue;
    }

    @Override
    protected DirectMessageListenerContainer createContainerInstance() {
        return new DirectMessageListenerContainer();
    }

    @Override
    protected void initializeContainer(DirectMessageListenerContainer instance, RabbitListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        if (this.taskScheduler != null) {
            instance.setTaskScheduler(this.taskScheduler);
        }
        if (this.monitorInterval != null) {
            instance.setMonitorInterval(this.monitorInterval);
        }
        if (endpoint.getConcurrency() != null) {
            try {
                instance.setConsumersPerQueue(Integer.parseInt(endpoint.getConcurrency()));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Failed to parse concurrency: " + e.getMessage());
            }
        } else if (this.consumersPerQueue != null) {
            instance.setConsumersPerQueue(this.consumersPerQueue);
        }
    }
}

