/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.mockito;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mockito.internal.stubbing.defaultanswers.ForwardsInvocations;
import org.mockito.invocation.InvocationOnMock;
import org.springframework.lang.Nullable;

public class LatchCountDownAndCallRealMethodAnswer
extends ForwardsInvocations {
    private static final long serialVersionUID = 1L;
    private final transient CountDownLatch latch;
    private final Set<Exception> exceptions = Collections.synchronizedSet(new LinkedHashSet());
    private final boolean hasDelegate;

    public LatchCountDownAndCallRealMethodAnswer(int count, @Nullable Object delegate) {
        super(delegate);
        this.latch = new CountDownLatch(count);
        this.hasDelegate = delegate != null;
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        try {
            if (this.hasDelegate) {
                Object object = super.answer(invocation);
                return object;
            }
            invocation.callRealMethod();
        }
        catch (Exception e) {
            this.exceptions.add(e);
            throw e;
        }
        finally {
            this.latch.countDown();
        }
        return null;
    }

    public boolean await(int timeout) throws InterruptedException {
        return this.latch.await(timeout, TimeUnit.SECONDS);
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Collection<Exception> getExceptions() {
        Set<Exception> set = this.exceptions;
        synchronized (set) {
            return new LinkedHashSet<Exception>(this.exceptions);
        }
    }
}

