/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import com.rabbitmq.client.ConnectionFactory;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.amqp.rabbit.junit.BrokerRunningSupport;
import org.springframework.amqp.rabbit.junit.RabbitAvailable;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;

public class RabbitAvailableCondition
implements ExecutionCondition,
AfterEachCallback,
AfterAllCallback,
ParameterResolver {
    private static final String BROKER_RUNNING_BEAN = "brokerRunning";
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@RabbitAvailable is not present");
    private static final ThreadLocal<BrokerRunningSupport> BROKER_RUNNING_HOLDER = new ThreadLocal();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)((AnnotatedElement)element.get()), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        if (annotations.get(RabbitAvailable.class).isPresent()) {
            RabbitAvailable rabbit = (RabbitAvailable)annotations.get(RabbitAvailable.class).synthesize();
            try {
                String[] queues = rabbit.queues();
                BrokerRunningSupport brokerRunning = (BrokerRunningSupport)this.getStore(context).get((Object)BROKER_RUNNING_BEAN, BrokerRunningSupport.class);
                if (brokerRunning == null) {
                    brokerRunning = rabbit.management() ? BrokerRunningSupport.isBrokerAndManagementRunningWithEmptyQueues(queues) : BrokerRunningSupport.isRunningWithEmptyQueues(queues);
                }
                brokerRunning.setPurgeAfterEach(rabbit.purgeAfterEach());
                brokerRunning.test();
                BROKER_RUNNING_HOLDER.set(brokerRunning);
                ExtensionContext.Store store = this.getStore(context);
                store.put((Object)BROKER_RUNNING_BEAN, (Object)brokerRunning);
                store.put((Object)"queuesToDelete", (Object)queues);
                return ConditionEvaluationResult.enabled((String)"RabbitMQ is available");
            }
            catch (Exception e) {
                if (BrokerRunningSupport.fatal()) {
                    throw new IllegalStateException("Required RabbitMQ is not available", e);
                }
                return ConditionEvaluationResult.disabled((String)"Tests Ignored: RabbitMQ is not available");
            }
        }
        return ENABLED;
    }

    public void afterEach(ExtensionContext context) {
        BrokerRunningSupport brokerRunning = BROKER_RUNNING_HOLDER.get();
        if (brokerRunning != null && brokerRunning.isPurgeAfterEach()) {
            brokerRunning.purgeTestQueues();
        }
    }

    public void afterAll(ExtensionContext context) {
        BROKER_RUNNING_HOLDER.remove();
        ExtensionContext.Store store = this.getStore(context);
        BrokerRunningSupport brokerRunning = (BrokerRunningSupport)store.remove((Object)BROKER_RUNNING_BEAN, BrokerRunningSupport.class);
        if (brokerRunning != null) {
            brokerRunning.removeTestQueues(new String[0]);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type.equals(ConnectionFactory.class) || type.equals(BrokerRunningSupport.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        BrokerRunningSupport brokerRunning = this.getParentStore(context).get((Object)BROKER_RUNNING_BEAN, BrokerRunningSupport.class) == null ? (BrokerRunningSupport)this.getStore(context).get((Object)BROKER_RUNNING_BEAN, BrokerRunningSupport.class) : (BrokerRunningSupport)this.getParentStore(context).get((Object)BROKER_RUNNING_BEAN, BrokerRunningSupport.class);
        Assert.state((brokerRunning != null ? 1 : 0) != 0, (String)"Could not find brokerRunning instance");
        Class<?> type = parameterContext.getParameter().getType();
        return type.equals(ConnectionFactory.class) ? brokerRunning.getConnectionFactory() : brokerRunning;
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
    }

    private ExtensionContext.Store getParentStore(ExtensionContext context) {
        ExtensionContext parent = (ExtensionContext)context.getParent().get();
        return parent.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), parent}));
    }

    public static BrokerRunningSupport getBrokerRunning() {
        return BROKER_RUNNING_HOLDER.get();
    }
}

