/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import com.rabbitmq.client.ConnectionFactory;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.amqp.rabbit.junit.BrokerRunningSupport;

public final class BrokerRunning
extends TestWatcher {
    private static final Log LOGGER = LogFactory.getLog(BrokerRunningSupport.class);
    private final BrokerRunningSupport brokerRunning;

    public static void setEnvironmentVariableOverrides(Map<String, String> environmentVariables) {
        BrokerRunningSupport.setEnvironmentVariableOverrides(environmentVariables);
    }

    public static void clearEnvironmentVariableOverrides() {
        BrokerRunningSupport.clearEnvironmentVariableOverrides();
    }

    public static BrokerRunning isRunningWithEmptyQueues(String ... names) {
        return new BrokerRunning(true, names);
    }

    public static BrokerRunning isRunning() {
        return new BrokerRunning(true, new String[0]);
    }

    public static BrokerRunning isNotRunning() {
        return new BrokerRunning(false, new String[0]);
    }

    public static BrokerRunning isBrokerAndManagementRunning() {
        return new BrokerRunning(false, true);
    }

    public static BrokerRunning isBrokerAndManagementRunningWithEmptyQueues(String ... queues) {
        return new BrokerRunning(true, true, queues);
    }

    private BrokerRunning(boolean purge, String ... queues) {
        this(purge, false, queues);
    }

    private BrokerRunning(boolean purge, boolean management, String ... queues) {
        this.brokerRunning = new BrokerRunningSupport(purge, management, queues);
    }

    private BrokerRunning(String ... queues) {
        this(false, queues);
    }

    private BrokerRunning() {
        this(BrokerRunningSupport.DEFAULT_QUEUE_NAME);
    }

    private BrokerRunning(boolean purge, boolean management) {
        this(purge, management, BrokerRunningSupport.DEFAULT_QUEUE_NAME);
    }

    public void setPort(int port) {
        this.brokerRunning.setPort(port);
    }

    public void setHostName(String hostName) {
        this.brokerRunning.setHostName(hostName);
    }

    public void setUser(String user) {
        this.brokerRunning.setUser(user);
    }

    public void setPassword(String password) {
        this.brokerRunning.setPassword(password);
    }

    public void setAdminUri(String adminUri) {
        this.brokerRunning.setAdminUri(adminUri);
    }

    public void setAdminUser(String user) {
        this.brokerRunning.setAdminUser(user);
    }

    public void setAdminPassword(String password) {
        this.brokerRunning.setAdminPassword(password);
    }

    public int getPort() {
        return this.brokerRunning.getPort();
    }

    public String getHostName() {
        return this.brokerRunning.getHostName();
    }

    public String getUser() {
        return this.brokerRunning.getUser();
    }

    public String getPassword() {
        return this.brokerRunning.getPassword();
    }

    public String getAdminUser() {
        return this.brokerRunning.getAdminUser();
    }

    public String getAdminPassword() {
        return this.brokerRunning.getAdminPassword();
    }

    public Statement apply(Statement base, Description description) {
        try {
            this.brokerRunning.test();
        }
        catch (BrokerRunningSupport.BrokerNotAliveException e) {
            LOGGER.warn((Object)("Not executing tests because basic connectivity test failed: " + e.getMessage()));
            if (BrokerRunning.fatal()) {
                Assert.fail((String)"RabbitMQ Broker is required, but not available");
            }
            Assume.assumeNoException((Throwable)e);
        }
        return super.apply(base, description);
    }

    public void isUp() {
        this.brokerRunning.test();
    }

    public static boolean fatal() {
        return BrokerRunningSupport.fatal();
    }

    public String generateId() {
        return this.brokerRunning.generateId();
    }

    public void removeTestQueues(String ... additionalQueues) {
        this.brokerRunning.removeTestQueues(additionalQueues);
    }

    public void purgeTestQueues() {
        this.brokerRunning.purgeTestQueues();
    }

    public void deleteQueues(String ... queuesToDelete) {
        this.brokerRunning.deleteQueues(queuesToDelete);
    }

    public void deleteExchanges(String ... exchanges) {
        this.brokerRunning.deleteExchanges(exchanges);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.brokerRunning.getConnectionFactory();
    }

    public String getAdminUri() {
        return this.brokerRunning.getAdminUri();
    }
}

