/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vertexai.palm2;

import org.springframework.ai.autoconfigure.vertexai.palm2.VertexAiPalm2ConnectionProperties;
import org.springframework.ai.autoconfigure.vertexai.palm2.VertexAiPalm2EmbeddingProperties;
import org.springframework.ai.autoconfigure.vertexai.palm2.VertexAiPlam2ChatProperties;
import org.springframework.ai.vertexai.palm2.VertexAiPaLm2ChatModel;
import org.springframework.ai.vertexai.palm2.VertexAiPaLm2EmbeddingModel;
import org.springframework.ai.vertexai.palm2.api.VertexAiPaLm2Api;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={VertexAiPaLm2Api.class})
@EnableConfigurationProperties(value={VertexAiPalm2ConnectionProperties.class, VertexAiPlam2ChatProperties.class, VertexAiPalm2EmbeddingProperties.class})
public class VertexAiPalm2AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAiPaLm2Api vertexAiApi(VertexAiPalm2ConnectionProperties connectionProperties, VertexAiPalm2EmbeddingProperties embeddingAiProperties, VertexAiPlam2ChatProperties chatProperties, RestClient.Builder restClientBuilder) {
        return new VertexAiPaLm2Api(connectionProperties.getBaseUrl(), connectionProperties.getApiKey(), chatProperties.getModel(), embeddingAiProperties.getModel(), restClientBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiPaLm2ChatModel vertexAiChatModel(VertexAiPaLm2Api vertexAiApi, VertexAiPlam2ChatProperties chatProperties) {
        return new VertexAiPaLm2ChatModel(vertexAiApi, chatProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiPaLm2EmbeddingModel vertexAiEmbeddingModel(VertexAiPaLm2Api vertexAiApi) {
        return new VertexAiPaLm2EmbeddingModel(vertexAiApi);
    }
}

