/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.mongo;

import org.springframework.ai.autoconfigure.vectorstore.mongo.MongoDBAtlasVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.MongoDBAtlasVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={MongoDataAutoConfiguration.class})
@ConditionalOnClass(value={MongoDBAtlasVectorStore.class, EmbeddingModel.class, MongoTemplate.class})
@EnableConfigurationProperties(value={MongoDBAtlasVectorStoreProperties.class})
public class MongoDBAtlasVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MongoDBAtlasVectorStore vectorStore(MongoTemplate mongoTemplate, EmbeddingModel embeddingModel, MongoDBAtlasVectorStoreProperties properties) {
        MongoDBAtlasVectorStore.MongoDBVectorStoreConfig.Builder builder = MongoDBAtlasVectorStore.MongoDBVectorStoreConfig.builder();
        if (StringUtils.hasText((String)properties.getCollectionName())) {
            builder.withCollectionName(properties.getCollectionName());
        }
        if (StringUtils.hasText((String)properties.getPathName())) {
            builder.withPathName(properties.getPathName());
        }
        if (StringUtils.hasText((String)properties.getIndexName())) {
            builder.withVectorIndexName(properties.getIndexName());
        }
        MongoDBAtlasVectorStore.MongoDBVectorStoreConfig config = builder.build();
        return new MongoDBAtlasVectorStore(mongoTemplate, embeddingModel, config, properties.isInitializeSchema());
    }
}

