/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.milvus;

import org.springframework.ai.autoconfigure.CommonVectorStoreProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.vectorstore.milvus")
public class MilvusVectorStoreProperties
extends CommonVectorStoreProperties {
    public static final String CONFIG_PREFIX = "spring.ai.vectorstore.milvus";
    private String databaseName = "default";
    private String collectionName = "vector_store";
    private int embeddingDimension = 1536;
    private MilvusIndexType indexType = MilvusIndexType.IVF_FLAT;
    private MilvusMetricType metricType = MilvusMetricType.COSINE;
    private String indexParameters = "{\"nlist\":1024}";

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        Assert.hasText((String)databaseName, (String)"Database name should not be empty.");
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        Assert.hasText((String)collectionName, (String)"Collection name should not be empty.");
        this.collectionName = collectionName;
    }

    public int getEmbeddingDimension() {
        return this.embeddingDimension;
    }

    public void setEmbeddingDimension(int embeddingDimension) {
        Assert.isTrue((embeddingDimension > 0 ? 1 : 0) != 0, (String)"Embedding dimension should be a positive value.");
        this.embeddingDimension = embeddingDimension;
    }

    public MilvusIndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(MilvusIndexType indexType) {
        Assert.notNull((Object)((Object)indexType), (String)"Index type can not be null");
        this.indexType = indexType;
    }

    public MilvusMetricType getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MilvusMetricType metricType) {
        Assert.notNull((Object)((Object)metricType), (String)"MetricType can not be null");
        this.metricType = metricType;
    }

    public String getIndexParameters() {
        return this.indexParameters;
    }

    public void setIndexParameters(String indexParameters) {
        Assert.notNull((Object)indexParameters, (String)"indexParameters can not be null");
        this.indexParameters = indexParameters;
    }

    public static enum MilvusIndexType {
        INVALID,
        FLAT,
        IVF_FLAT,
        IVF_SQ8,
        IVF_PQ,
        HNSW,
        DISKANN,
        AUTOINDEX,
        SCANN,
        GPU_IVF_FLAT,
        GPU_IVF_PQ,
        BIN_FLAT,
        BIN_IVF_FLAT,
        TRIE,
        STL_SORT;

    }

    public static enum MilvusMetricType {
        INVALID,
        L2,
        IP,
        COSINE,
        HAMMING,
        JACCARD;

    }
}

