/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.chat.client;

import org.springframework.ai.autoconfigure.chat.client.ChatClientBuilderConfigurer;
import org.springframework.ai.autoconfigure.chat.client.ChatClientBuilderProperties;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.ChatClientCustomizer;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

@AutoConfiguration
@ConditionalOnClass(value={ChatClient.class})
@EnableConfigurationProperties(value={ChatClientBuilderProperties.class})
@ConditionalOnProperty(prefix="spring.ai.chat.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ChatClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ChatClientBuilderConfigurer chatClientBuilderConfigurer(ObjectProvider<ChatClientCustomizer> customizerProvider) {
        ChatClientBuilderConfigurer configurer = new ChatClientBuilderConfigurer();
        configurer.setChatClientCustomizers(customizerProvider.orderedStream().toList());
        return configurer;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    ChatClient.Builder chatClientBuilder(ChatClientBuilderConfigurer chatClientBuilderConfigurer, ChatModel chatModel) {
        ChatClient.Builder builder = ChatClient.builder((ChatModel)chatModel);
        return chatClientBuilderConfigurer.configure(builder);
    }
}

