/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAiAudioApi {
    private final RestClient restClient;
    private final WebClient webClient;

    public OpenAiAudioApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> authHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
            }
            h.addAll(headers);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(authHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(authHeaders).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResponseEntity<byte[]> createSpeech(SpeechRequest requestBody) {
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/audio/speech", new Object[0])).body((Object)requestBody).retrieve().toEntity(byte[].class);
    }

    public Flux<ResponseEntity<byte[]>> stream(SpeechRequest requestBody) {
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/audio/speech", new Object[0])).body((Publisher)Mono.just((Object)requestBody), SpeechRequest.class).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM}).exchangeToFlux(clientResponse -> {
            HttpHeaders headers = clientResponse.headers().asHttpHeaders();
            return clientResponse.bodyToFlux(byte[].class).map(bytes -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(bytes));
        });
    }

    public ResponseEntity<?> createTranscription(TranscriptionRequest requestBody) {
        return this.createTranscription(requestBody, requestBody.responseFormat().getResponseType());
    }

    public <T> ResponseEntity<T> createTranscription(TranscriptionRequest requestBody, Class<T> responseType) {
        LinkedMultiValueMap multipartBody = new LinkedMultiValueMap();
        multipartBody.add((Object)"file", (Object)new ByteArrayResource(requestBody.file()){

            public String getFilename() {
                return "audio.webm";
            }
        });
        multipartBody.add((Object)"model", (Object)requestBody.model());
        multipartBody.add((Object)"language", (Object)requestBody.language());
        multipartBody.add((Object)"prompt", (Object)requestBody.prompt());
        multipartBody.add((Object)"response_format", (Object)requestBody.responseFormat().getValue());
        multipartBody.add((Object)"temperature", (Object)requestBody.temperature());
        if (requestBody.granularityType() != null) {
            Assert.isTrue((requestBody.responseFormat() == TranscriptResponseFormat.VERBOSE_JSON ? 1 : 0) != 0, (String)"response_format must be set to verbose_json to use timestamp granularities.");
            multipartBody.add((Object)"timestamp_granularities[]", (Object)requestBody.granularityType().getValue());
        }
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/audio/transcriptions", new Object[0])).body((Object)multipartBody).retrieve().toEntity(responseType);
    }

    public ResponseEntity<?> createTranslation(TranslationRequest requestBody) {
        return this.createTranslation(requestBody, requestBody.responseFormat().getResponseType());
    }

    public <T> ResponseEntity<T> createTranslation(TranslationRequest requestBody, Class<T> responseType) {
        LinkedMultiValueMap multipartBody = new LinkedMultiValueMap();
        multipartBody.add((Object)"file", (Object)new ByteArrayResource(requestBody.file()){

            public String getFilename() {
                return "audio.webm";
            }
        });
        multipartBody.add((Object)"model", (Object)requestBody.model());
        multipartBody.add((Object)"prompt", (Object)requestBody.prompt());
        multipartBody.add((Object)"response_format", (Object)requestBody.responseFormat().getValue());
        multipartBody.add((Object)"temperature", (Object)requestBody.temperature());
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/audio/translations", new Object[0])).body((Object)multipartBody).retrieve().toEntity(responseType);
    }

    public static class Builder {
        private String baseUrl = "https://api.openai.com";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"webClientBuilder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public OpenAiAudioApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new OpenAiAudioApi(this.baseUrl, this.apiKey, this.headers, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record SpeechRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") String input, @JsonProperty(value="voice") String voice, @JsonProperty(value="response_format") AudioResponseFormat responseFormat, @JsonProperty(value="speed") Float speed) {
        public static Builder builder() {
            return new Builder();
        }

        public static enum AudioResponseFormat {
            MP3("mp3"),
            OPUS("opus"),
            AAC("aac"),
            FLAC("flac"),
            WAV("wav"),
            PCM("pcm");

            public final String value;

            private AudioResponseFormat(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private String model = TtsModel.TTS_1.getValue();
            private String input;
            private String voice;
            private AudioResponseFormat responseFormat = AudioResponseFormat.MP3;
            private Float speed;

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder input(String input) {
                this.input = input;
                return this;
            }

            public Builder voice(String voice) {
                this.voice = voice;
                return this;
            }

            public Builder voice(Voice voice) {
                this.voice = voice.getValue();
                return this;
            }

            public Builder responseFormat(AudioResponseFormat responseFormat) {
                this.responseFormat = responseFormat;
                return this;
            }

            public Builder speed(Float speed) {
                this.speed = speed;
                return this;
            }

            public SpeechRequest build() {
                Assert.hasText((String)this.model, (String)"model must not be empty");
                Assert.hasText((String)this.input, (String)"input must not be empty");
                return new SpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
            }
        }

        public static enum Voice {
            ALLOY("alloy"),
            ECHO("echo"),
            FABLE("fable"),
            ONYX("onyx"),
            NOVA("nova"),
            SHIMMER("shimmer"),
            SAGE("sage"),
            CORAL("coral"),
            ASH("ash");

            public final String value;

            private Voice(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TranscriptionRequest(@JsonProperty(value="file") byte[] file, @JsonProperty(value="model") String model, @JsonProperty(value="language") String language, @JsonProperty(value="prompt") String prompt, @JsonProperty(value="response_format") TranscriptResponseFormat responseFormat, @JsonProperty(value="temperature") Float temperature, @JsonProperty(value="timestamp_granularities") GranularityType granularityType) {
        public static Builder builder() {
            return new Builder();
        }

        public static enum GranularityType {
            WORD("word"),
            SEGMENT("segment");

            public final String value;

            private GranularityType(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private byte[] file;
            private String model = WhisperModel.WHISPER_1.getValue();
            private String language;
            private String prompt;
            private TranscriptResponseFormat responseFormat = TranscriptResponseFormat.JSON;
            private Float temperature;
            private GranularityType granularityType;

            public Builder file(byte[] file) {
                this.file = file;
                return this;
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder language(String language) {
                this.language = language;
                return this;
            }

            public Builder prompt(String prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder responseFormat(TranscriptResponseFormat responseFormat) {
                this.responseFormat = responseFormat;
                return this;
            }

            public Builder temperature(Float temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder granularityType(GranularityType granularityType) {
                this.granularityType = granularityType;
                return this;
            }

            public TranscriptionRequest build() {
                Assert.notNull((Object)this.file, (String)"file must not be null");
                Assert.hasText((String)this.model, (String)"model must not be empty");
                Assert.notNull((Object)((Object)this.responseFormat), (String)"response_format must not be null");
                return new TranscriptionRequest(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, this.granularityType);
            }
        }
    }

    public static enum TranscriptResponseFormat {
        JSON("json", StructuredResponse.class),
        TEXT("text", String.class),
        SRT("srt", String.class),
        VERBOSE_JSON("verbose_json", StructuredResponse.class),
        VTT("vtt", String.class);

        public final String value;
        public final Class<?> responseType;

        private TranscriptResponseFormat(String value, Class<?> responseType) {
            this.value = value;
            this.responseType = responseType;
        }

        public boolean isJsonType() {
            return this == JSON || this == VERBOSE_JSON;
        }

        public String getValue() {
            return this.value;
        }

        public Class<?> getResponseType() {
            return this.responseType;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TranslationRequest(@JsonProperty(value="file") byte[] file, @JsonProperty(value="model") String model, @JsonProperty(value="prompt") String prompt, @JsonProperty(value="response_format") TranscriptResponseFormat responseFormat, @JsonProperty(value="temperature") Float temperature) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private byte[] file;
            private String model = WhisperModel.WHISPER_1.getValue();
            private String prompt;
            private TranscriptResponseFormat responseFormat = TranscriptResponseFormat.JSON;
            private Float temperature;

            public Builder file(byte[] file) {
                this.file = file;
                return this;
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder prompt(String prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder responseFormat(TranscriptResponseFormat responseFormat) {
                this.responseFormat = responseFormat;
                return this;
            }

            public Builder temperature(Float temperature) {
                this.temperature = temperature;
                return this;
            }

            public TranslationRequest build() {
                Assert.notNull((Object)this.file, (String)"file must not be null");
                Assert.hasText((String)this.model, (String)"model must not be empty");
                Assert.notNull((Object)((Object)this.responseFormat), (String)"response_format must not be null");
                return new TranslationRequest(this.file, this.model, this.prompt, this.responseFormat, this.temperature);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record StructuredResponse(@JsonProperty(value="language") String language, @JsonProperty(value="duration") Float duration, @JsonProperty(value="text") String text, @JsonProperty(value="words") List<Word> words, @JsonProperty(value="segments") List<Segment> segments) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Segment(@JsonProperty(value="id") Integer id, @JsonProperty(value="seek") Integer seek, @JsonProperty(value="start") Float start, @JsonProperty(value="end") Float end, @JsonProperty(value="text") String text, @JsonProperty(value="tokens") List<Integer> tokens, @JsonProperty(value="temperature") Float temperature, @JsonProperty(value="avg_logprob") Float avgLogprob, @JsonProperty(value="compression_ratio") Float compressionRatio, @JsonProperty(value="no_speech_prob") Float noSpeechProb) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Word(@JsonProperty(value="word") String word, @JsonProperty(value="start") Float start, @JsonProperty(value="end") Float end) {
        }
    }

    public static enum WhisperModel {
        WHISPER_1("whisper-1");

        public final String value;

        private WhisperModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TtsModel {
        TTS_1("tts-1"),
        TTS_1_HD("tts-1-hd");

        public final String value;

        private TtsModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

