/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OpenAiImageApi {
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.DALL_E_3.getValue();
    private final RestClient restClient;

    public OpenAiImageApi(String openAiToken) {
        this("https://api.openai.com", openAiToken, RestClient.builder());
    }

    public OpenAiImageApi(String baseUrl, String openAiToken, RestClient.Builder restClientBuilder) {
        this(baseUrl, openAiToken, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public OpenAiImageApi(String baseUrl, String apiKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this(baseUrl, apiKey, (MultiValueMap<String, String>)CollectionUtils.toMultiValueMap(Map.of()), restClientBuilder, responseErrorHandler);
    }

    public OpenAiImageApi(String baseUrl, String apiKey, MultiValueMap<String, String> headers, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(h -> {
            h.setBearerAuth(apiKey);
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        }).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<OpenAiImageResponse> createImage(OpenAiImageRequest openAiImageRequest) {
        Assert.notNull((Object)openAiImageRequest, (String)"Image request cannot be null.");
        Assert.hasLength((String)openAiImageRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("v1/images/generations", new Object[0])).body((Object)openAiImageRequest).retrieve().toEntity(OpenAiImageResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiImageRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="model") String model, @JsonProperty(value="n") Integer n, @JsonProperty(value="quality") String quality, @JsonProperty(value="response_format") String responseFormat, @JsonProperty(value="size") String size, @JsonProperty(value="style") String style, @JsonProperty(value="user") String user) {
        public OpenAiImageRequest(String prompt, String model) {
            this(prompt, model, null, null, null, null, null, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiImageResponse(@JsonProperty(value="created") Long created, @JsonProperty(value="data") List<Data> data) {
    }

    public static enum ImageModel {
        DALL_E_3("dall-e-3"),
        DALL_E_2("dall-e-2");

        private final String value;

        private ImageModel(String model) {
            this.value = model;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Data(@JsonProperty(value="url") String url, @JsonProperty(value="b64_json") String b64Json, @JsonProperty(value="revised_prompt") String revisedPrompt) {
    }
}

