/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata.audio;

import java.util.HashMap;
import org.springframework.ai.chat.metadata.EmptyRateLimit;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.model.ResponseMetadata;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.metadata.OpenAiRateLimit;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenAiAudioTranscriptionResponseMetadata
extends HashMap<String, Object>
implements ResponseMetadata {
    protected static final String AI_METADATA_STRING = "{ @type: %1$s, rateLimit: %4$s }";
    public static final OpenAiAudioTranscriptionResponseMetadata NULL = new OpenAiAudioTranscriptionResponseMetadata(){};
    @Nullable
    private RateLimit rateLimit;

    public static OpenAiAudioTranscriptionResponseMetadata from(OpenAiAudioApi.StructuredResponse result) {
        Assert.notNull((Object)result, (String)"OpenAI Transcription must not be null");
        OpenAiAudioTranscriptionResponseMetadata transcriptionResponseMetadata = new OpenAiAudioTranscriptionResponseMetadata();
        return transcriptionResponseMetadata;
    }

    public static OpenAiAudioTranscriptionResponseMetadata from(String result) {
        Assert.notNull((Object)result, (String)"OpenAI Transcription must not be null");
        OpenAiAudioTranscriptionResponseMetadata transcriptionResponseMetadata = new OpenAiAudioTranscriptionResponseMetadata();
        return transcriptionResponseMetadata;
    }

    protected OpenAiAudioTranscriptionResponseMetadata() {
        this((OpenAiRateLimit)null);
    }

    protected OpenAiAudioTranscriptionResponseMetadata(@Nullable OpenAiRateLimit rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Nullable
    public RateLimit getRateLimit() {
        RateLimit rateLimit = this.rateLimit;
        return rateLimit != null ? rateLimit : new EmptyRateLimit();
    }

    public OpenAiAudioTranscriptionResponseMetadata withRateLimit(RateLimit rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Override
    public String toString() {
        return AI_METADATA_STRING.formatted(this.getClass().getName(), this.getRateLimit());
    }
}

