/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiChatOptions
implements FunctionCallingOptions,
ChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequency_penalty")
    private Float frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="logprobs")
    private Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    private Integer topLogprobs;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="presence_penalty")
    private Float presencePenalty;
    @JsonProperty(value="response_format")
    private OpenAiApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @JsonProperty(value="seed")
    private Integer seed;
    @NestedConfigurationProperty
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    @NestedConfigurationProperty
    @JsonProperty(value="tools")
    private List<OpenAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonProperty(value="user")
    private String user;
    @NestedConfigurationProperty
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @NestedConfigurationProperty
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public OpenAiApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(OpenAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public List<OpenAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<OpenAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functionNames) {
        this.functions = functionNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.frequencyPenalty == null ? 0 : this.frequencyPenalty.hashCode());
        result = 31 * result + (this.logitBias == null ? 0 : this.logitBias.hashCode());
        result = 31 * result + (this.logprobs == null ? 0 : this.logprobs.hashCode());
        result = 31 * result + (this.topLogprobs == null ? 0 : this.topLogprobs.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.n == null ? 0 : this.n.hashCode());
        result = 31 * result + (this.presencePenalty == null ? 0 : this.presencePenalty.hashCode());
        result = 31 * result + (this.responseFormat == null ? 0 : this.responseFormat.hashCode());
        result = 31 * result + (this.seed == null ? 0 : this.seed.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        result = 31 * result + (this.tools == null ? 0 : this.tools.hashCode());
        result = 31 * result + (this.toolChoice == null ? 0 : this.toolChoice.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenAiChatOptions other = (OpenAiChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.frequencyPenalty == null ? other.frequencyPenalty != null : !this.frequencyPenalty.equals(other.frequencyPenalty)) {
            return false;
        }
        if (this.logitBias == null ? other.logitBias != null : !this.logitBias.equals(other.logitBias)) {
            return false;
        }
        if (this.logprobs == null ? other.logprobs != null : !this.logprobs.equals(other.logprobs)) {
            return false;
        }
        if (this.topLogprobs == null ? other.topLogprobs != null : !this.topLogprobs.equals(other.topLogprobs)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.n == null ? other.n != null : !this.n.equals(other.n)) {
            return false;
        }
        if (this.presencePenalty == null ? other.presencePenalty != null : !this.presencePenalty.equals(other.presencePenalty)) {
            return false;
        }
        if (this.responseFormat == null ? other.responseFormat != null : !this.responseFormat.equals(other.responseFormat)) {
            return false;
        }
        if (this.seed == null ? other.seed != null : !this.seed.equals(other.seed)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        if (this.topP == null ? other.topP != null : !this.topP.equals(other.topP)) {
            return false;
        }
        if (this.tools == null ? other.tools != null : !this.tools.equals(other.tools)) {
            return false;
        }
        if (this.toolChoice == null ? other.toolChoice != null : !this.toolChoice.equals(other.toolChoice)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @JsonIgnore
    public Integer getTopK() {
        throw new UnsupportedOperationException("Unimplemented method 'getTopK'");
    }

    @JsonIgnore
    public void setTopK(Integer topK) {
        throw new UnsupportedOperationException("Unimplemented method 'setTopK'");
    }

    public static OpenAiChatOptions fromOptions(OpenAiChatOptions fromOptions) {
        return OpenAiChatOptions.builder().withModel(fromOptions.getModel()).withFrequencyPenalty(fromOptions.getFrequencyPenalty()).withLogitBias(fromOptions.getLogitBias()).withLogprobs(fromOptions.getLogprobs()).withTopLogprobs(fromOptions.getTopLogprobs()).withMaxTokens(fromOptions.getMaxTokens()).withN(fromOptions.getN()).withPresencePenalty(fromOptions.getPresencePenalty()).withResponseFormat(fromOptions.getResponseFormat()).withSeed(fromOptions.getSeed()).withStop(fromOptions.getStop()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withTools(fromOptions.getTools()).withToolChoice(fromOptions.getToolChoice()).withUser(fromOptions.getUser()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withFunctions(fromOptions.getFunctions()).build();
    }

    public static class Builder {
        protected OpenAiChatOptions options;

        public Builder() {
            this.options = new OpenAiChatOptions();
        }

        public Builder(OpenAiChatOptions options) {
            this.options = options;
        }

        public Builder withModel(String model) {
            this.options.model = model;
            return this;
        }

        public Builder withModel(OpenAiApi.ChatModel openAiChatModel) {
            this.options.model = openAiChatModel.getModelName();
            return this;
        }

        public Builder withFrequencyPenalty(Float frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder withLogitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder withLogprobs(Boolean logprobs) {
            this.options.logprobs = logprobs;
            return this;
        }

        public Builder withTopLogprobs(Integer topLogprobs) {
            this.options.topLogprobs = topLogprobs;
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder withN(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder withPresencePenalty(Float presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder withResponseFormat(OpenAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder withSeed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder withStop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder withTemperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withTools(List<OpenAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder withToolChoice(String toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder withUser(String user) {
            this.options.user = user;
            return this;
        }

        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public OpenAiChatOptions build() {
            return this.options;
        }
    }
}

