/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.model.tool.DefaultToolCallingManager;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingProperties;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.execution.DefaultToolExecutionExceptionProcessor;
import org.springframework.ai.tool.execution.ToolExecutionExceptionProcessor;
import org.springframework.ai.tool.observation.ToolCallingContentObservationFilter;
import org.springframework.ai.tool.observation.ToolCallingObservationConvention;
import org.springframework.ai.tool.resolution.DelegatingToolCallbackResolver;
import org.springframework.ai.tool.resolution.SpringBeanToolCallbackResolver;
import org.springframework.ai.tool.resolution.StaticToolCallbackResolver;
import org.springframework.ai.tool.resolution.ToolCallbackResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@ConditionalOnClass(value={ChatModel.class})
@EnableConfigurationProperties(value={ToolCallingProperties.class})
public class ToolCallingAutoConfiguration
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ToolCallingAutoConfiguration.class);
    private static final String EXCLUDE_MCP_TOOL_CALLBACK_PROVIDER = "org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration.toolcallbackprovider.mcp-excluded";

    @Bean
    @ConditionalOnMissingBean
    ToolCallbackResolver toolCallbackResolver(GenericApplicationContext applicationContext, List<ToolCallback> toolCallbacks, @Qualifier(value="org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration.toolcallbackprovider.mcp-excluded") List<ToolCallbackProvider> tcbProviders) {
        ArrayList<ToolCallback> allFunctionAndToolCallbacks = new ArrayList<ToolCallback>(toolCallbacks);
        tcbProviders.stream().filter(pr -> !ToolCallingAutoConfiguration.isMcpToolCallbackProvider(ResolvableType.forInstance((Object)pr))).map(pr -> List.of(pr.getToolCallbacks())).forEach(allFunctionAndToolCallbacks::addAll);
        StaticToolCallbackResolver staticToolCallbackResolver = new StaticToolCallbackResolver(allFunctionAndToolCallbacks);
        SpringBeanToolCallbackResolver springBeanToolCallbackResolver = SpringBeanToolCallbackResolver.builder().applicationContext(applicationContext).build();
        return new DelegatingToolCallbackResolver(List.of(staticToolCallbackResolver, springBeanToolCallbackResolver));
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (!(registry instanceof DefaultListableBeanFactory)) {
            return;
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)registry;
        AbstractBeanDefinition excludeMcpToolCallbackProviderBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(List.class, () -> {
            String[] providerNames = beanFactory.getBeanNamesForType(ToolCallbackProvider.class);
            return Arrays.stream(providerNames).filter(name -> !ToolCallingAutoConfiguration.isMcpToolCallbackProvider(beanFactory.getBeanDefinition(name).getResolvableType())).map(arg_0 -> ((DefaultListableBeanFactory)beanFactory).getBean(arg_0)).filter(ToolCallbackProvider.class::isInstance).map(ToolCallbackProvider.class::cast).toList();
        }).setScope("singleton").setLazyInit(true).getBeanDefinition();
        registry.registerBeanDefinition(EXCLUDE_MCP_TOOL_CALLBACK_PROVIDER, (BeanDefinition)excludeMcpToolCallbackProviderBeanDefinition);
    }

    private static boolean isMcpToolCallbackProvider(ResolvableType type) {
        if (type.getType().getTypeName().equals("org.springframework.ai.mcp.SyncMcpToolCallbackProvider") || type.getType().getTypeName().equals("org.springframework.ai.mcp.AsyncMcpToolCallbackProvider")) {
            return true;
        }
        ResolvableType superType = type.getSuperType();
        return superType != ResolvableType.NONE && ToolCallingAutoConfiguration.isMcpToolCallbackProvider(superType);
    }

    @Bean
    @ConditionalOnMissingBean
    ToolExecutionExceptionProcessor toolExecutionExceptionProcessor(ToolCallingProperties properties) {
        ArrayList<Class<? extends RuntimeException>> rethrownExceptions = new ArrayList<Class<? extends RuntimeException>>();
        Class<? extends RuntimeException> oauth2Exception = ToolCallingAutoConfiguration.getClassOrNull("org.springframework.security.oauth2.client.ClientAuthorizationException");
        if (oauth2Exception != null) {
            rethrownExceptions.add(oauth2Exception);
        }
        return DefaultToolExecutionExceptionProcessor.builder().alwaysThrow(properties.isThrowExceptionOnError()).rethrowExceptions(rethrownExceptions).build();
    }

    @Bean
    @ConditionalOnMissingBean
    ToolCallingManager toolCallingManager(ToolCallbackResolver toolCallbackResolver, ToolExecutionExceptionProcessor toolExecutionExceptionProcessor, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ToolCallingObservationConvention> observationConvention) {
        DefaultToolCallingManager toolCallingManager = ToolCallingManager.builder().observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).toolCallbackResolver(toolCallbackResolver).toolExecutionExceptionProcessor(toolExecutionExceptionProcessor).build();
        observationConvention.ifAvailable(arg_0 -> ((DefaultToolCallingManager)toolCallingManager).setObservationConvention(arg_0));
        return toolCallingManager;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.tools.observations", name={"include-content"}, havingValue="true")
    ToolCallingContentObservationFilter toolCallingContentObservationFilter() {
        logger.warn("You have enabled the inclusion of the tool call arguments and result in the observations, with the risk of exposing sensitive or private information. Please, be careful!");
        return new ToolCallingContentObservationFilter();
    }

    private static Class<? extends RuntimeException> getClassOrNull(String className) {
        try {
            Class clazz = ClassUtils.forName((String)className, null);
            if (RuntimeException.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            logger.debug("Class {} is not a subclass of RuntimeException", (Object)className);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Cannot load class: {}", (Object)className);
        }
        catch (Exception e) {
            logger.debug("Error loading class: {}", (Object)className, (Object)e);
        }
        return null;
    }
}

