/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.utils.SpringDocKotlinUtils;
import org.springframework.lang.Nullable;

public class SchemaUtils {
    public static final Boolean JAVA_FIELD_NULLABLE_DEFAULT = true;
    public static final List<String> ANNOTATIONS_FOR_REQUIRED = Arrays.asList("NotNull", "NonNull", "NotBlank", "NotEmpty");
    public static final List<String> ANNOTATIONS_FOR_NULLABLE = Arrays.asList("Nullable");
    private static final Set<Class<?>> OPTIONAL_TYPES = new HashSet();
    private final Optional<SpringDocKotlinUtils> kotlinUtilsOptional;

    public SchemaUtils(Optional<SpringDocKotlinUtils> kotlinUtilsOptional) {
        this.kotlinUtilsOptional = kotlinUtilsOptional;
    }

    public static boolean swaggerVisible(@Nullable Schema schema, @Nullable Parameter parameter) {
        if (parameter != null) {
            return !parameter.hidden();
        }
        if (schema != null) {
            return !schema.hidden();
        }
        return true;
    }

    @Nullable
    public static Boolean swaggerRequired(@Nullable Schema schema, @Nullable Parameter parameter) {
        if (parameter != null && parameter.required()) {
            return true;
        }
        if (schema != null) {
            if (schema.required() || schema.requiredMode() == Schema.RequiredMode.REQUIRED) {
                return true;
            }
            if (schema.requiredMode() == Schema.RequiredMode.NOT_REQUIRED) {
                return false;
            }
        }
        return null;
    }

    public static boolean annotatedNotNull(List<Annotation> annotations) {
        Collection annotationSimpleNames = annotations.stream().map(annotation -> annotation.annotationType().getSimpleName()).collect(Collectors.toSet());
        return ANNOTATIONS_FOR_REQUIRED.stream().anyMatch(annotationSimpleNames::contains);
    }

    public boolean fieldNullable(Field field) {
        Boolean kotlin;
        if (field.getType().isPrimitive()) {
            return false;
        }
        if (OPTIONAL_TYPES.stream().anyMatch(c -> c.isAssignableFrom(field.getType()))) {
            return true;
        }
        Boolean ann = SchemaUtils.nullableFromAnnotations(field);
        if (ann != null) {
            return ann;
        }
        if (this.kotlinUtilsOptional.isPresent() && SpringDocKotlinUtils.isKotlinDeclaringClass(field) && (kotlin = SpringDocKotlinUtils.kotlinNullability(field)) != null) {
            return kotlin;
        }
        return JAVA_FIELD_NULLABLE_DEFAULT;
    }

    public boolean fieldRequired(Field field, Schema schema, Parameter parameter) {
        Boolean swagger = SchemaUtils.swaggerRequired(schema, parameter);
        if (swagger != null) {
            return swagger;
        }
        if (OPTIONAL_TYPES.stream().anyMatch(c -> c.isAssignableFrom(field.getType()))) {
            return false;
        }
        if (SchemaUtils.hasNullableAnnotation(field) || SchemaUtils.hasNullableOnGetter(field) || SchemaUtils.hasNullableOnCtorParam(field)) {
            return false;
        }
        if (SchemaUtils.hasNotNullAnnotation(field) || SchemaUtils.hasNotNullOnGetter(field) || SchemaUtils.hasNotNullOnCtorParam(field)) {
            return true;
        }
        if (this.kotlinUtilsOptional.isPresent() && SpringDocKotlinUtils.isKotlinDeclaringClass(field)) {
            if (this.fieldNullable(field)) {
                return false;
            }
            Boolean hasDefault = SpringDocKotlinUtils.kotlinConstructorParamIsOptional(field);
            return !Boolean.TRUE.equals(hasDefault);
        }
        JsonProperty jp = SchemaUtils.getJsonProperty(field);
        return jp != null && jp.required();
    }

    public static void applyValidationsToSchema(io.swagger.v3.oas.models.media.Schema<?> schema, List<Annotation> annotations, String openapiVersion) {
        String specVersion;
        annotations.forEach(anno -> {
            String annotationName = anno.annotationType().getSimpleName();
            if (annotationName.equals(Positive.class.getSimpleName())) {
                if (SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openapiVersion)) {
                    schema.setExclusiveMinimumValue(BigDecimal.ZERO);
                } else {
                    schema.setMinimum(BigDecimal.ZERO);
                    schema.setExclusiveMinimum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(PositiveOrZero.class.getSimpleName())) {
                schema.setMinimum(BigDecimal.ZERO);
            }
            if (annotationName.equals(NegativeOrZero.class.getSimpleName())) {
                schema.setMaximum(BigDecimal.ZERO);
            }
            if (annotationName.equals(Negative.class.getSimpleName())) {
                if (SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openapiVersion)) {
                    schema.setExclusiveMaximumValue(BigDecimal.ZERO);
                } else {
                    schema.setMaximum(BigDecimal.ZERO);
                    schema.setExclusiveMaximum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(Min.class.getSimpleName())) {
                schema.setMinimum(BigDecimal.valueOf(((Min)anno).value()));
            }
            if (annotationName.equals(Max.class.getSimpleName())) {
                schema.setMaximum(BigDecimal.valueOf(((Max)anno).value()));
            }
            if (annotationName.equals(DecimalMin.class.getSimpleName())) {
                DecimalMin min = (DecimalMin)anno;
                if (min.inclusive()) {
                    schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
                } else {
                    schema.setExclusiveMinimum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(DecimalMax.class.getSimpleName())) {
                DecimalMax max = (DecimalMax)anno;
                if (max.inclusive()) {
                    schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
                } else {
                    schema.setExclusiveMaximum(Boolean.valueOf(true));
                }
            }
            if (annotationName.equals(Size.class.getSimpleName())) {
                String type = schema.getType();
                if (type == null && schema.getTypes() != null && schema.getTypes().size() == 1) {
                    type = (String)schema.getTypes().iterator().next();
                }
                if ("array".equals(type)) {
                    schema.setMinItems(Integer.valueOf(((Size)anno).min()));
                    schema.setMaxItems(Integer.valueOf(((Size)anno).max()));
                } else if ("string".equals(type)) {
                    schema.setMinLength(Integer.valueOf(((Size)anno).min()));
                    schema.setMaxLength(Integer.valueOf(((Size)anno).max()));
                }
            }
            if (annotationName.equals(Pattern.class.getSimpleName())) {
                schema.setPattern(((Pattern)anno).regexp());
            }
        });
        if (schema != null && SchemaUtils.annotatedNotNull(annotations) && !"V30".equals(specVersion = schema.getSpecVersion().name())) {
            schema.setNullable(Boolean.valueOf(false));
        }
    }

    private static Boolean nullableFromAnnotations(Field field) {
        if (SchemaUtils.hasNullableAnnotation(field)) {
            return true;
        }
        if (SchemaUtils.hasNotNullAnnotation(field)) {
            return false;
        }
        Method getter = SchemaUtils.findGetter(field);
        if (getter != null) {
            if (SchemaUtils.hasNullableAnnotation(getter)) {
                return true;
            }
            if (SchemaUtils.hasNotNullAnnotation(getter)) {
                return false;
            }
        }
        return null;
    }

    private static boolean hasNullableAnnotation(AnnotatedElement el) {
        if (el == null) {
            return false;
        }
        for (Annotation ann : el.getAnnotations()) {
            if (!ANNOTATIONS_FOR_NULLABLE.contains(ann.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNotNullAnnotation(AnnotatedElement el) {
        if (el == null) {
            return false;
        }
        for (Annotation ann : el.getAnnotations()) {
            String simpleName = ann.annotationType().getSimpleName();
            if (!ANNOTATIONS_FOR_REQUIRED.contains(simpleName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNullableOnGetter(Field f) {
        Method g = SchemaUtils.findGetter(f);
        return g != null && SchemaUtils.hasNullableAnnotation(g);
    }

    private static boolean hasNotNullOnGetter(Field f) {
        Method g = SchemaUtils.findGetter(f);
        return g != null && SchemaUtils.hasNotNullAnnotation(g);
    }

    private static boolean hasNullableOnCtorParam(Field f) {
        return SchemaUtils.ctorParamHasAnyAnnotationSimpleName(f, ANNOTATIONS_FOR_NULLABLE);
    }

    private static boolean hasNotNullOnCtorParam(Field f) {
        return SchemaUtils.ctorParamHasAnyAnnotationSimpleName(f, ANNOTATIONS_FOR_REQUIRED);
    }

    private static boolean ctorParamHasAnyAnnotationSimpleName(Field f, Collection<String> simpleNames) {
        if (f == null || simpleNames == null || simpleNames.isEmpty()) {
            return false;
        }
        String fieldName = f.getName();
        Class<?> declaring = f.getDeclaringClass();
        try {
            for (Constructor<?> ctor : declaring.getDeclaredConstructors()) {
                java.lang.reflect.Parameter[] params;
                for (java.lang.reflect.Parameter p : params = ctor.getParameters()) {
                    if (fieldName.equals(p.getName()) && SchemaUtils.paramHasAnyAnnotationSimpleName(p, simpleNames)) {
                        return true;
                    }
                    if (!SchemaUtils.hasJsonPropertyName(p, fieldName) || !SchemaUtils.paramHasAnyAnnotationSimpleName(p, simpleNames)) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean paramHasAnyAnnotationSimpleName(java.lang.reflect.Parameter p, Collection<String> simpleNames) {
        for (Annotation ann : p.getAnnotations()) {
            if (!simpleNames.contains(ann.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasJsonPropertyName(java.lang.reflect.Parameter p, String expected) {
        try {
            JsonProperty jp = p.getAnnotation(JsonProperty.class);
            return jp != null && expected.equals(jp.value());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static Method findGetter(Field f) {
        String[] names;
        String[] stringArray;
        String n = f.getName();
        String cap = Character.toUpperCase(n.charAt(0)) + n.substring(1);
        if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "is" + cap;
            stringArray = stringArray2;
            stringArray2[1] = "get" + cap;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "get" + cap;
        }
        for (String m : names = stringArray) {
            try {
                return f.getDeclaringClass().getMethod(m, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private static JsonProperty getJsonProperty(Field f) {
        JsonProperty jp = f.getAnnotation(JsonProperty.class);
        if (jp != null) {
            return jp;
        }
        Method g = SchemaUtils.findGetter(f);
        if (g != null) {
            return g.getAnnotation(JsonProperty.class);
        }
        return null;
    }

    static {
        OPTIONAL_TYPES.add(Optional.class);
        OPTIONAL_TYPES.add(OptionalInt.class);
        OPTIONAL_TYPES.add(OptionalLong.class);
        OPTIONAL_TYPES.add(OptionalDouble.class);
    }
}

