/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.event;

import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.launch.server.ServerInfo;
import org.springblade.core.log.event.ApiLogEvent;
import org.springblade.core.log.feign.ILogClient;
import org.springblade.core.log.model.LogApi;
import org.springblade.core.log.utils.LogAbstractUtil;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

public class ApiLogListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogListener.class);
    private final ILogClient logService;
    private final ServerInfo serverInfo;
    private final BladeProperties bladeProperties;

    @Async
    @Order
    @EventListener(value={ApiLogEvent.class})
    public void saveApiLog(ApiLogEvent event) {
        Map source = (Map)event.getSource();
        LogApi logApi = (LogApi)source.get("log");
        LogAbstractUtil.addOtherInfoToLog(logApi, this.bladeProperties, this.serverInfo);
        this.logService.saveApiLog(logApi);
    }

    @Generated
    public ApiLogListener(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        this.logService = logService;
        this.serverInfo = serverInfo;
        this.bladeProperties = bladeProperties;
    }
}

