/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.auth;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;

public class AuthFun {
    public boolean permitAll() {
        return true;
    }

    public boolean denyAll() {
        return this.hasRole("admin");
    }

    public boolean hasRole(String role) {
        return this.hasAnyRole(role);
    }

    public boolean hasAnyRole(String ... role) {
        String userRole = SecureUtil.getUser().getRoleName();
        if (StringUtil.isBlank((CharSequence)userRole)) {
            return false;
        }
        Object[] roles = Func.toStrArray((String)userRole);
        for (String r : role) {
            if (!CollectionUtil.contains((Object[])roles, (Object)r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCrypto() {
        HttpServletRequest request = WebUtil.getRequest();
        String auth = Objects.requireNonNull(request).getHeader("blade-auth");
        return SecureUtil.isCrypto(StringUtil.isNotBlank((CharSequence)auth) ? auth : request.getParameter("blade-auth"));
    }
}

