/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.se.constraint.Constraint;
import org.sonarsource.analyzer.commons.collections.PCollections;
import org.sonarsource.analyzer.commons.collections.PMap;

public class ConstraintsByDomain {
    private final PMap<Class<? extends Constraint>, Constraint> constraintPMap;
    private static final ConstraintsByDomain EMPTY = new ConstraintsByDomain((PMap<Class<? extends Constraint>, Constraint>)PCollections.emptyMap());

    private ConstraintsByDomain(PMap<Class<? extends Constraint>, Constraint> constraintPMap) {
        this.constraintPMap = constraintPMap;
    }

    public static ConstraintsByDomain empty() {
        return EMPTY;
    }

    public ConstraintsByDomain remove(Class<? extends Constraint> domain) {
        PMap remove = this.constraintPMap.remove(domain);
        if (remove == this.constraintPMap) {
            return this;
        }
        return remove.isEmpty() ? EMPTY : new ConstraintsByDomain((PMap<Class<? extends Constraint>, Constraint>)remove);
    }

    @Nullable
    public Constraint get(Class<? extends Constraint> domain) {
        return (Constraint)this.constraintPMap.get(domain);
    }

    public boolean hasConstraint(Constraint constraint) {
        return constraint.equals(this.constraintPMap.get(constraint.getClass()));
    }

    public void forEach(BiConsumer<Class<? extends Constraint>, Constraint> action) {
        this.constraintPMap.forEach(action);
    }

    public boolean isEmpty() {
        return this.constraintPMap.isEmpty();
    }

    public ConstraintsByDomain put(Constraint constraint) {
        PMap newConstraints = this.constraintPMap.put(constraint.getClass(), (Object)constraint);
        return newConstraints == this.constraintPMap ? this : new ConstraintsByDomain((PMap<Class<? extends Constraint>, Constraint>)newConstraints);
    }

    public Stream<Constraint> stream() {
        Stream.Builder builder = Stream.builder();
        this.constraintPMap.forEach((d, constraint) -> builder.add(constraint));
        return builder.build();
    }

    public Stream<Class<? extends Constraint>> domains() {
        Stream.Builder builder = Stream.builder();
        this.constraintPMap.forEach((domain, constraint) -> builder.add(domain));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintsByDomain that = (ConstraintsByDomain)o;
        return this.constraintPMap.equals(that.constraintPMap);
    }

    public String toString() {
        return this.stream().map((Function<Constraint, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/sonar/java/se/constraint/Constraint;)Ljava/lang/String;)()).sorted().collect(Collectors.joining(",", "[", "]"));
    }

    public int hashCode() {
        return this.constraintPMap.hashCode();
    }
}

